/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQueryResult;

public class ReportQuery
extends ReadAllQuery {
    public static final int ShouldReturnSingleResult = 1;
    public static final int ShouldReturnSingleValue = 2;
    public static final int ShouldReturnSingleAttribute = 3;
    public static final int ShouldReturnWithoutReportQueryResult = 4;
    public static final int FULL_PRIMARY_KEY = 2;
    public static final int FIRST_PRIMARY_KEY = 1;
    public static final int NO_PRIMARY_KEY = 0;
    protected static final Boolean RESULT_IGNORED = true;
    protected int shouldRetrievePrimaryKeys;
    protected Vector names;
    protected Vector items;
    protected Vector groupByExpressions;
    protected Expression havingExpression;
    protected int returnChoice;
    protected boolean addToConstructorItem;
    protected Class resultConstructorClass;
    protected Class[] constructorArgTypes;
    protected List constructorMappings;
    protected HashSet returnedKeys;

    public ReportQuery() {
        this.queryMechanism = new ExpressionQueryMechanism(this);
        this.items = NonSynchronizedVector.newInstance();
        this.shouldRetrievePrimaryKeys = 0;
        this.groupByExpressions = NonSynchronizedVector.newInstance(3);
        this.havingExpression = null;
        this.addToConstructorItem = false;
        this.setLockMode((short)0);
    }

    public ReportQuery(Class javaClass, Expression expression) {
        this();
        this.defaultBuilder = expression.getBuilder();
        this.setReferenceClass(javaClass);
        this.setSelectionCriteria(expression);
    }

    public ReportQuery(Class javaClass, ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
        this.setReferenceClass(javaClass);
    }

    public ReportQuery(ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
    }

    public void addAttribute(String itemName) {
        this.addItem(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addAttribute(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression);
    }

    public void addAttribute(String itemName, Expression attributeExpression, Class type) {
        this.addItem(itemName, attributeExpression, type);
    }

    public void addAverage(String itemName) {
        this.addAverage(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addAverage(String itemName, Class resultType) {
        this.addAverage(itemName, this.getExpressionBuilder().get(itemName), resultType);
    }

    public void addAverage(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.average());
    }

    public void addAverage(String itemName, Expression attributeExpression, Class resultType) {
        this.addItem(itemName, attributeExpression.average(), resultType);
    }

    public void addConstructorReportItem(ConstructorReportItem item) {
        this.addItem(item);
    }

    public void addCount() {
        this.addCount("COUNT", this.getExpressionBuilder());
    }

    public void addCount(String attributeName) {
        this.addCount(attributeName, this.getExpressionBuilder().get(attributeName));
    }

    public void addCount(String attributeName, Class resultType) {
        this.addCount(attributeName, this.getExpressionBuilder().get(attributeName), resultType);
    }

    public void addCount(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.count());
    }

    public void addCount(String itemName, Expression attributeExpression, Class resultType) {
        this.addItem(itemName, attributeExpression.count(), resultType);
    }

    public void addFunctionItem(String itemName, Expression attributeExpression, String functionName) {
        Expression functionExpression = attributeExpression;
        functionExpression = attributeExpression.getFunction(functionName);
        ReportItem item = new ReportItem(itemName, functionExpression);
        this.addItem(item);
        this.setIsPrepared(false);
    }

    public void addGrouping(String attributeName) {
        this.addGrouping(this.getExpressionBuilder().get(attributeName));
    }

    public void addGrouping(Expression expression) {
        this.getGroupByExpressions().addElement(expression);
        this.setIsPrepared(false);
    }

    public void setHavingExpression(Expression expression) {
        this.havingExpression = expression;
        this.setIsPrepared(false);
    }

    private void addItem(ReportItem item) {
        if (this.addToConstructorItem && this.getItems().size() > 0 && ((ReportItem)this.getItems().lastElement()).isConstructorItem()) {
            ((ConstructorReportItem)this.getItems().lastElement()).addItem(item);
        } else {
            this.getItems().addElement(item);
        }
        this.setIsPrepared(false);
    }

    public void addItem(String itemName, Expression attributeExpression) {
        ReportItem item = new ReportItem(itemName, attributeExpression);
        this.addItem(item);
        this.setIsPrepared(false);
    }

    public void addItem(String itemName, Expression attributeExpression, List joinedExpressions) {
        ReportItem item = new ReportItem(itemName, attributeExpression);
        item.getJoinedAttributeManager().setJoinedAttributeExpressions_(joinedExpressions);
        this.addItem(item);
    }

    protected void addItem(String itemName, Expression attributeExpression, Class resultType) {
        ReportItem item = new ReportItem(itemName, attributeExpression);
        item.setResultType(resultType);
        this.addItem(item);
    }

    public void addMaximum(String itemName) {
        this.addMaximum(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addMaximum(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.maximum());
    }

    public void addMinimum(String itemName) {
        this.addMinimum(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addMinimum(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.minimum());
    }

    public void addStandardDeviation(String itemName) {
        this.addStandardDeviation(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addStandardDeviation(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.standardDeviation());
    }

    public void addSum(String itemName) {
        this.addSum(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addSum(String itemName, Class resultType) {
        this.addSum(itemName, this.getExpressionBuilder().get(itemName), resultType);
    }

    public void addSum(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.sum());
    }

    public void addSum(String itemName, Expression attributeExpression, Class resultType) {
        this.addItem(itemName, attributeExpression.sum(), resultType);
    }

    public void addVariance(String itemName) {
        this.addVariance(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addVariance(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.variance());
    }

    public ConstructorReportItem beginAddingConstructorArguments(Class constructorClass) {
        ConstructorReportItem citem = new ConstructorReportItem(constructorClass.getName());
        citem.setResultType(constructorClass);
        this.getItems().add(citem);
        this.setIsPrepared(false);
        this.addToConstructorItem = true;
        return citem;
    }

    public ConstructorReportItem beginAddingConstructorArguments(Class constructorClass, Class[] constructorArgTypes) {
        ConstructorReportItem citem = this.beginAddingConstructorArguments(constructorClass);
        citem.setConstructorArgTypes(constructorArgTypes);
        return citem;
    }

    public Object buildObject(AbstractRecord row) {
        return this.buildObject(row, null);
    }

    public Object buildObject(AbstractRecord row, Vector toManyJoinData) {
        ReportQueryResult reportQueryResult = new ReportQueryResult(this, row, toManyJoinData);
        if (this.returnedKeys != null) {
            if (this.returnedKeys.contains(reportQueryResult.getResultKey())) {
                return RESULT_IGNORED;
            }
            this.returnedKeys.add(reportQueryResult.getResultKey());
        }
        if (this.shouldReturnSingleAttribute()) {
            return reportQueryResult.getResults().firstElement();
        }
        if (this.shouldReturnWithoutReportQueryResult()) {
            if (reportQueryResult.getResults().size() == 1) {
                return reportQueryResult.getResults().firstElement();
            }
            return reportQueryResult.toArray();
        }
        return reportQueryResult;
    }

    public Object buildObjects(Vector rows) {
        if (this.shouldReturnSingleResult() || this.shouldReturnSingleValue()) {
            if (rows.isEmpty()) {
                return null;
            }
            ReportQueryResult result = (ReportQueryResult)this.buildObject((AbstractRecord)rows.firstElement(), rows);
            if (this.shouldReturnSingleValue()) {
                return result.elements().nextElement();
            }
            return result;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object reportResults = containerPolicy.containerInstance(rows.size());
        if (this.shouldDistinctBeUsed()) {
            this.returnedKeys = new HashSet();
        }
        Enumeration rowsEnum = rows.elements();
        while (rowsEnum.hasMoreElements()) {
            Object result = this.buildObject((AbstractRecord)rowsEnum.nextElement(), rows);
            if (result == RESULT_IGNORED) continue;
            containerPolicy.addInto(result, reportResults, this.getSession());
        }
        if (this.shouldCacheQueryResults()) {
            this.setTemporaryCachedQueryResults(reportResults);
        }
        return reportResults;
    }

    protected Object checkEarlyReturnImpl(AbstractSession session, AbstractRecord translationRow) {
        if (this.shouldCheckCacheOnly()) {
            throw QueryException.cannotSetShouldCheckCacheOnlyOnReportQuery();
        }
        return null;
    }

    public Object clone() {
        ReportQuery cloneQuery = (ReportQuery)super.clone();
        cloneQuery.setItems(new Vector(this.getItems().size()));
        for (ReportItem item : this.getItems()) {
            ReportItem newItem = (ReportItem)item.clone();
            if (item.getJoinedAttributeManagerInternal() != null) {
                JoinedAttributeManager manager = (JoinedAttributeManager)item.getJoinedAttributeManager().clone();
                manager.setBaseQuery(cloneQuery);
                newItem.setJoinedAttributeManager(manager);
            }
            cloneQuery.addItem(newItem);
        }
        return cloneQuery;
    }

    public void copyReportItems(Map alreadyDone) {
        Cloneable item;
        int i;
        this.items = (Vector)this.items.clone();
        for (i = this.items.size() - 1; i >= 0; --i) {
            item = (ReportItem)this.items.elementAt(i);
            Expression expression = ((ReportItem)item).getAttributeExpression();
            if (expression != null && alreadyDone.get(expression.getBuilder()) != null) {
                expression = expression.copiedVersionFrom(alreadyDone);
            }
            this.items.set(i, new ReportItem(((ReportItem)item).getName(), expression));
        }
        if (this.groupByExpressions != null) {
            this.groupByExpressions = (Vector)this.groupByExpressions.clone();
            for (i = this.groupByExpressions.size() - 1; i >= 0; --i) {
                item = (Expression)this.groupByExpressions.elementAt(i);
                if (alreadyDone.get(((Expression)item).getBuilder()) == null) continue;
                this.groupByExpressions.set(i, ((Expression)item).copiedVersionFrom(alreadyDone));
            }
        }
        if (this.orderByExpressions != null) {
            for (i = this.orderByExpressions.size() - 1; i >= 0; --i) {
                item = (Expression)this.orderByExpressions.elementAt(i);
                if (alreadyDone.get(((Expression)item).getBuilder()) == null) continue;
                this.orderByExpressions.set(i, ((Expression)item).copiedVersionFrom(alreadyDone));
            }
        }
    }

    public void dontRetrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(false);
        this.setIsPrepared(false);
    }

    public void dontReturnSingleAttribute() {
        if (this.shouldReturnSingleAttribute()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleResult() {
        if (this.shouldReturnSingleResult()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleValue() {
        if (this.shouldReturnSingleValue()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnWithoutReportQueryResult() {
        if (this.shouldReturnWithoutReportQueryResult()) {
            this.returnChoice = 0;
        }
    }

    public void endAddingToConstructorItem() {
        this.addToConstructorItem = false;
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.isLockQuery() && this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                unitOfWork.beginTransaction();
                unitOfWork.setWasTransactionBegunPrematurely(true);
            }
        }
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            return this.getDescriptor().getInterfacePolicy().selectAllObjectsUsingMultipleTableSubclassRead(this);
        }
        return this.buildObjects(this.getQueryMechanism().selectAllReportQueryRows());
    }

    public Object extractRemoteResult(Transporter transporter) {
        return transporter.getObject();
    }

    public Vector getGroupByExpressions() {
        return this.groupByExpressions;
    }

    protected void setGroupByExpressions(Vector groupByExpressions) {
        this.groupByExpressions = groupByExpressions;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public Vector getQueryExpressions() {
        NonSynchronizedVector fieldExpressions = NonSynchronizedVector.newInstance(this.getItems().size());
        if (this.shouldRetrieveFirstPrimaryKey() && !this.getDescriptor().getPrimaryKeyFields().isEmpty()) {
            ((Vector)fieldExpressions).addElement(this.getDescriptor().getPrimaryKeyFields().get(0));
        }
        if (this.shouldRetrievePrimaryKeys()) {
            ((Vector)fieldExpressions).addAll(this.getDescriptor().getPrimaryKeyFields());
        }
        return fieldExpressions;
    }

    public Vector getItemExpressions() {
        Vector<Cloneable> fieldExpressions = new Vector<Cloneable>(this.getItems().size());
        if (this.shouldRetrieveFirstPrimaryKey() && !this.getDescriptor().getPrimaryKeyFields().isEmpty()) {
            fieldExpressions.addElement(this.getDescriptor().getPrimaryKeyFields().get(0));
        }
        if (this.shouldRetrievePrimaryKeys()) {
            fieldExpressions.addAll(this.getDescriptor().getPrimaryKeyFields());
        }
        Enumeration itemsEnum = this.getItems().elements();
        while (itemsEnum.hasMoreElements()) {
            ReportItem item = (ReportItem)itemsEnum.nextElement();
            Expression fieldExpression = item.getAttributeExpression();
            if (fieldExpression == null) continue;
            fieldExpressions.addElement(fieldExpression);
        }
        return fieldExpressions;
    }

    public Vector getItems() {
        return this.items;
    }

    protected void setItems(Vector items) {
        this.items = items;
    }

    public void clearItems() {
        this.items = new Vector();
        this.setIsPrepared(false);
    }

    public Vector getNames() {
        if (this.names == null) {
            this.names = NonSynchronizedVector.newInstance();
            Enumeration e = this.getItems().elements();
            while (e.hasMoreElements()) {
                this.names.addElement(((ReportItem)e.nextElement()).getName());
            }
        }
        return this.names;
    }

    protected void setNames(Vector names) {
        this.names = names;
    }

    public boolean isReportQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        if (this.prepareFromCachedQuery()) {
            return;
        }
        if (this.getItems().size() > 0) {
            try {
                Enumeration itemsEnum = this.getItems().elements();
                while (itemsEnum.hasMoreElements()) {
                    ((ReportItem)itemsEnum.nextElement()).initialize(this);
                }
            }
            catch (QueryException exception) {
                exception.setQuery(this);
                throw exception;
            }
        } else if (!this.shouldRetrievePrimaryKeys() && !this.shouldRetrieveFirstPrimaryKey()) {
            throw QueryException.noAttributesForReportQuery(this);
        }
        super.prepare();
    }

    public void prepareFromQuery(DatabaseQuery query) {
        super.prepareFromQuery(query);
        if (query.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)query;
            this.names = reportQuery.names;
            this.items = reportQuery.items;
            this.groupByExpressions = reportQuery.groupByExpressions;
            this.constructorArgTypes = reportQuery.constructorArgTypes;
            this.constructorMappings = reportQuery.constructorMappings;
            this.havingExpression = reportQuery.havingExpression;
            this.resultConstructorClass = reportQuery.resultConstructorClass;
            this.returnChoice = reportQuery.returnChoice;
            this.returnedKeys = reportQuery.returnedKeys;
            this.shouldRetrievePrimaryKeys = reportQuery.shouldRetrievePrimaryKeys;
        }
    }

    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && !this.hasBatchReadAttributes() && !this.hasHierarchicalExpressions() && !this.getContainerPolicy().isCursorPolicy();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReportQuery query = (ReportQuery)object;
        Vector items = this.getItems();
        Vector otherItems = query.getItems();
        int size = items.size();
        if (size != otherItems.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            if (items.get(index).equals(otherItems.get(index))) continue;
            return false;
        }
        Vector groupBys = this.getGroupByExpressions();
        Vector otherGroupBys = query.getGroupByExpressions();
        size = groupBys.size();
        if (size != otherGroupBys.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            if (groupBys.get(index).equals(otherGroupBys.get(index))) continue;
            return false;
        }
        if (this.getHavingExpression() != query.getHavingExpression() && this.getHavingExpression() != null && !this.getHavingExpression().equals(query.getHavingExpression())) {
            return false;
        }
        if (this.resultConstructorClass != query.resultConstructorClass) {
            return false;
        }
        if (this.returnChoice != query.returnChoice) {
            return false;
        }
        return this.shouldRetrievePrimaryKeys == query.shouldRetrievePrimaryKeys;
    }

    protected void prepareObjectAttributeCount(Map clonedExpressions) {
        this.prepareObjectAttributeCount(this.getItems(), clonedExpressions);
    }

    private void prepareObjectAttributeCount(List items, Map clonedExpressions) {
        int numOfReportItems = items.size();
        for (int i = 0; i < numOfReportItems; ++i) {
            Expression countArg;
            DatabaseMapping pk;
            FunctionExpression count;
            ReportItem item = (ReportItem)items.get(i);
            if (item == null) continue;
            if (item instanceof ConstructorReportItem) {
                this.prepareObjectAttributeCount(((ConstructorReportItem)item).getReportItems(), clonedExpressions);
                continue;
            }
            if (!(item.getAttributeExpression() instanceof FunctionExpression) || (count = (FunctionExpression)item.getAttributeExpression()).getOperator().getSelector() != 19) continue;
            Expression baseExp = count.getBaseExpression();
            boolean distinctUsed = false;
            if (baseExp.isFunctionExpression() && ((FunctionExpression)baseExp).getOperator().getSelector() == 87) {
                distinctUsed = true;
                baseExp = ((FunctionExpression)baseExp).getBaseExpression();
            }
            boolean outerJoin = false;
            ClassDescriptor newDescriptor = null;
            if (baseExp.isQueryKeyExpression()) {
                DatabaseMapping mapping = this.getLeafMappingFor(baseExp, this.getDescriptor());
                if (mapping != null && !mapping.isDirectToFieldMapping()) {
                    newDescriptor = mapping.getReferenceDescriptor();
                    outerJoin = ((QueryKeyExpression)baseExp).shouldUseOuterJoin();
                }
            } else if (baseExp.isExpressionBuilder()) {
                newDescriptor = this.getSession().getDescriptor(((ExpressionBuilder)baseExp).getQueryClass());
            }
            if (newDescriptor == null) continue;
            if (newDescriptor.hasSimplePrimaryKey() && newDescriptor.getPrimaryKeyFields().size() == 1) {
                pk = this.getMappingOfFirstPrimaryKey(newDescriptor);
                countArg = baseExp.get(pk.getAttributeName());
                if (distinctUsed) {
                    countArg = countArg.distinct();
                }
                count.setBaseExpression(countArg);
                count.getChildren().setElementAt(countArg, 0);
                continue;
            }
            if (!distinctUsed) {
                pk = this.getMappingOfFirstPrimaryKey(newDescriptor);
                countArg = baseExp.get(pk.getAttributeName());
                while (pk.isAggregateObjectMapping()) {
                    newDescriptor = ((AggregateObjectMapping)pk).getReferenceDescriptor();
                    pk = this.getMappingOfFirstPrimaryKey(newDescriptor);
                    countArg = countArg.get(pk.getAttributeName());
                }
                count.setBaseExpression(countArg);
                count.getChildren().setElementAt(countArg, 0);
                continue;
            }
            if (!outerJoin) {
                if (clonedExpressions != null) {
                    baseExp = clonedExpressions.get(baseExp.getBuilder()) != null ? baseExp.copiedVersionFrom(clonedExpressions) : baseExp.rebuildOn(this.getExpressionBuilder());
                }
                ExpressionBuilder countBuilder = baseExp.getBuilder();
                ExpressionBuilder outerBuilder = new ExpressionBuilder();
                ReportQuery subSelect = new ReportQuery(this.getReferenceClass(), countBuilder);
                subSelect.setShouldRetrieveFirstPrimaryKey(true);
                if (this.getSelectionCriteria() != null) {
                    outerBuilder.setQueryClass(newDescriptor.getJavaClass());
                    subSelect.setSelectionCriteria(baseExp.equal(outerBuilder).and(this.getSelectionCriteria()));
                } else {
                    subSelect.setSelectionCriteria(baseExp.equal(outerBuilder));
                }
                this.setSelectionCriteria(outerBuilder.exists(subSelect));
                count.setBaseExpression(outerBuilder);
                count.getChildren().setElementAt(outerBuilder, 0);
                this.setReferenceClass(newDescriptor.getJavaClass());
                this.changeDescriptor(this.getSession());
                continue;
            }
            throw QueryException.distinctCountOnOuterJoinedCompositePK(newDescriptor, this);
        }
    }

    private DatabaseMapping getMappingOfFirstPrimaryKey(ClassDescriptor descriptor) {
        if (descriptor != null) {
            for (DatabaseMapping m : descriptor.getMappings()) {
                if (!m.isPrimaryKeyMapping()) continue;
                return m;
            }
        }
        return null;
    }

    protected void prepareSelectAllRows() {
        this.prepareObjectAttributeCount(null);
        this.getQueryMechanism().prepareReportQuerySelectAllRows();
    }

    public synchronized void prepareSubSelect(AbstractSession session, AbstractRecord translationRow, Map clonedExpressions) throws QueryException {
        if (this.isPrepared()) {
            return;
        }
        this.setIsPrepared(true);
        this.setSession(session);
        this.setTranslationRow(translationRow);
        this.checkDescriptor(this.getSession());
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        try {
            Enumeration itemsEnum = this.getItems().elements();
            while (itemsEnum.hasMoreElements()) {
                ((ReportItem)itemsEnum.nextElement()).initialize(this);
            }
        }
        catch (QueryException exception) {
            exception.setQuery(this);
            throw exception;
        }
        this.prepareObjectAttributeCount(clonedExpressions);
        this.getQueryMechanism().prepareReportQuerySubSelect();
        this.setSession(null);
        this.setTranslationRow(null);
    }

    public void initializeFetchGroup() {
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return null;
    }

    public void retrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(true);
        this.setIsPrepared(false);
    }

    public void returnSingleAttribute() {
        this.returnChoice = 3;
    }

    public void returnSingleResult() {
        this.returnChoice = 1;
    }

    public void returnSingleValue() {
        this.returnChoice = 2;
    }

    public void returnWithoutReportQueryResult() {
        this.returnChoice = 4;
    }

    public void setShouldRetrievePrimaryKeys(boolean shouldRetrievePrimaryKeys) {
        this.shouldRetrievePrimaryKeys = shouldRetrievePrimaryKeys ? 2 : 0;
    }

    public void setShouldRetrieveFirstPrimaryKey(boolean shouldRetrieveFirstPrimaryKey) {
        this.shouldRetrievePrimaryKeys = shouldRetrieveFirstPrimaryKey ? 1 : 0;
    }

    public void setShouldReturnSingleAttribute(boolean newChoice) {
        if (newChoice) {
            this.returnSingleAttribute();
        } else {
            this.dontReturnSingleAttribute();
        }
    }

    public void setShouldReturnSingleResult(boolean newChoice) {
        if (newChoice) {
            this.returnSingleResult();
        } else {
            this.dontReturnSingleResult();
        }
    }

    public void setShouldReturnSingleValue(boolean newChoice) {
        if (newChoice) {
            this.returnSingleValue();
        } else {
            this.dontReturnSingleValue();
        }
    }

    public void setShouldReturnWithoutReportQueryResult(boolean newChoice) {
        if (newChoice) {
            this.returnWithoutReportQueryResult();
        } else {
            this.dontReturnWithoutReportQueryResult();
        }
    }

    public boolean shouldRetrievePrimaryKeys() {
        return this.shouldRetrievePrimaryKeys == 2;
    }

    public boolean shouldRetrieveFirstPrimaryKey() {
        return this.shouldRetrievePrimaryKeys == 1;
    }

    public boolean shouldReturnSingleAttribute() {
        return this.returnChoice == 3;
    }

    public boolean shouldReturnSingleResult() {
        return this.returnChoice == 1;
    }

    public boolean shouldReturnSingleValue() {
        return this.returnChoice == 2;
    }

    public boolean shouldReturnWithoutReportQueryResult() {
        return this.returnChoice == 4;
    }
}

