/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;

public class DoesExistQuery
extends DatabaseQuery {
    public static final int AssumeNonExistence = 1;
    public static final int AssumeExistence = 2;
    public static final int CheckCache = 3;
    public static final int CheckDatabase = 4;
    protected Vector primaryKey;
    protected Object object;
    protected int existencePolicy = 3;
    protected boolean checkDatabaseIfInvalid = true;
    public boolean checkCacheFirst = false;

    public DoesExistQuery() {
    }

    public DoesExistQuery(Object object) {
        this();
        this.object = object;
    }

    public DoesExistQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void assumeExistenceForDoesExist() {
        this.setExistencePolicy(2);
    }

    public void assumeNonExistenceForDoesExist() {
        this.setExistencePolicy(1);
    }

    public void checkCacheForDoesExist() {
        this.setExistencePolicy(3);
    }

    public void checkDatabaseForDoesExist() {
        this.setExistencePolicy(4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object checkEarlyReturn(Object object, Vector primaryKey, AbstractSession session, AbstractRecord translationRow) {
        this.buildSelectionCriteria(session);
        if (object == null) {
            return Boolean.FALSE;
        }
        ClassDescriptor descriptor = session.getDescriptor(object.getClass());
        if (primaryKey == null && (primaryKey = this.getPrimaryKey()) == null) {
            primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session);
        }
        if (primaryKey == null || primaryKey.contains(null)) {
            return Boolean.FALSE;
        }
        if (this.shouldCheckCacheForDoesExist() || this.checkCacheFirst) {
            CacheKey cacheKey;
            if (this.checkDatabaseIfInvalid && session.isUnitOfWork() && ((UnitOfWorkImpl)session).shouldReadFromDB()) {
                return null;
            }
            Class<?> objectClass = object.getClass();
            AbstractSession tempSession = session;
            while (tempSession.isUnitOfWork()) {
                cacheKey = tempSession.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, objectClass, descriptor);
                if (cacheKey != null) {
                    return Boolean.TRUE;
                }
                tempSession = ((UnitOfWorkImpl)tempSession).getParent();
            }
            cacheKey = tempSession.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, objectClass, descriptor);
            if (cacheKey != null) {
                boolean invalid;
                if (this.checkDatabaseIfInvalid) {
                    long currentTimeInMillis = System.currentTimeMillis();
                    invalid = session.getDescriptor(objectClass).getCacheInvalidationPolicy().isInvalidated(cacheKey, currentTimeInMillis);
                } else {
                    invalid = false;
                }
                if (invalid) return null;
                Object objectFromCache = cacheKey.getObject();
                if (!(session instanceof RepeatableWriteUnitOfWork) || ((RepeatableWriteUnitOfWork)session).getUnregisteredDeletedCloneForOriginal(objectFromCache) == null) return Boolean.TRUE;
                if (this.shouldCheckCacheForDoesExist()) {
                    return Boolean.FALSE;
                }
            } else if (this.shouldCheckCacheForDoesExist()) {
                return Boolean.FALSE;
            }
        }
        if (this.shouldAssumeNonExistenceForDoesExist()) {
            return Boolean.FALSE;
        }
        if (!this.shouldAssumeExistenceForDoesExist()) return null;
        return Boolean.TRUE;
    }

    public Object checkEarlyReturn(AbstractSession session, AbstractRecord translationRow) {
        return this.checkEarlyReturn(this.getObject(), this.getPrimaryKey(), session, translationRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        DatabaseField field = this.getDoesExistField();
        AbstractRecord databaseRow = this.getQueryMechanism().selectRowForDoesExist(field);
        return new Boolean(databaseRow != null);
    }

    protected DatabaseField getDoesExistField() {
        return this.getDescriptor().getPrimaryKeyFields().get(0);
    }

    public int getExistencePolicy() {
        return this.existencePolicy;
    }

    public Object getObject() {
        return this.object;
    }

    public Vector getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getReferenceClass() {
        if (this.getObject() == null) {
            return null;
        }
        return this.getObject().getClass();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    protected void prepare() throws QueryException {
        if (this.getDescriptor() == null) {
            this.setDescriptor(this.getSession().getDescriptor(this.getObject()));
        }
        if (this.getObject() != null) {
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        super.prepare();
        this.getQueryMechanism().prepareDoesExist(this.getDoesExistField());
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        if (this.getDescriptor() == null) {
            this.setDescriptor(this.getSession().getDescriptor(this.getObject().getClass()));
        }
        if (this.getPrimaryKey() == null) {
            this.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getObject(), this.getSession()));
        }
        if (this.getTranslationRow() == null || this.getTranslationRow().isEmpty()) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }

    public void setExistencePolicy(int existencePolicy) {
        this.existencePolicy = existencePolicy;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setPrimaryKey(Vector primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean shouldAssumeExistenceForDoesExist() {
        return this.existencePolicy == 2;
    }

    public boolean shouldAssumeNonExistenceForDoesExist() {
        return this.existencePolicy == 1;
    }

    public boolean shouldCheckCacheForDoesExist() {
        return this.existencePolicy == 3;
    }

    public boolean shouldCheckDatabaseForDoesExist() {
        return this.existencePolicy == 4;
    }

    public void setCheckCacheFirst(boolean checkCacheFirst) {
        this.checkCacheFirst = checkCacheFirst;
    }

    public boolean getCheckCacheFirst() {
        return this.checkCacheFirst;
    }

    public void setCheckDatabaseIfInvalid(boolean checkCacheFirst) {
        this.checkCacheFirst = checkCacheFirst;
    }

    public boolean getCheckDatabaseIfInvalid() {
        return this.checkCacheFirst;
    }
}

