/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshalListener;
import org.eclipse.persistence.jaxb.attachment.AttachmentMarshallerAdapter;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JAXBMarshaller
implements Marshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLMarshaller xmlMarshaller;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";

    public JAXBMarshaller(XMLMarshaller newXMLMarshaller, JAXBIntrospector newIntrospector) {
        this.xmlMarshaller = newXMLMarshaller;
        this.xmlMarshaller.setEncoding("UTF-8");
        this.xmlMarshaller.setFormattedOutput(false);
        JAXBMarshalListener listener = new JAXBMarshalListener(this);
        this.xmlMarshaller.setMarshalListener(listener);
    }

    private XMLRoot createXMLRootFromJAXBElement(JAXBElement elt) {
        XMLRoot xmlroot = new XMLRoot();
        xmlroot.setObject(elt.getValue());
        QName qname = elt.getName();
        xmlroot.setLocalName(qname.getLocalPart());
        xmlroot.setNamespaceURI(qname.getNamespaceURI());
        return xmlroot;
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlMarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return ((AttachmentMarshallerAdapter)this.xmlMarshaller.getAttachmentMarshaller()).getAttachmentMarshaller();
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public Marshaller.Listener getListener() {
        return ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).getListener();
    }

    public Node getNode(Object object) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if ("jaxb.formatted.output".equals(key)) {
            return new Boolean(this.xmlMarshaller.isFormattedOutput());
        }
        if ("jaxb.encoding".equals(key)) {
            return this.xmlMarshaller.getEncoding();
        }
        if ("jaxb.schemaLocation".equals(key)) {
            return this.xmlMarshaller.getSchemaLocation();
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(key)) {
            return this.xmlMarshaller.getNoNamespaceSchemaLocation();
        }
        if ("jaxb.fragment".equals(key)) {
            return new Boolean(this.xmlMarshaller.isFragment());
        }
        throw new PropertyException("Unsupported Property");
    }

    public Schema getSchema() {
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema();
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        if (object == null || contentHandler == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, contentHandler);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, XMLEventWriter eventWriter) {
    }

    public void marshal(Object object, Node node) throws JAXBException {
        if (object == null || node == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, node);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        if (object == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, outputStream);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, Result result) throws JAXBException {
        if (object == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, result);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, XMLStreamWriter streamWriter) {
    }

    public void marshal(Object object, Writer writer) throws JAXBException {
        if (object == null || writer == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof JAXBElement) {
            object = this.createXMLRootFromJAXBElement((JAXBElement)object);
        }
        try {
            this.xmlMarshaller.marshal(object, writer);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlMarshaller.getProperty(XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlMarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        this.xmlMarshaller.setAttachmentMarshaller(new AttachmentMarshallerAdapter(attachmentMarshaller));
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? new DefaultValidationEventHandler() : newValidationEventHandler;
    }

    public void setListener(Marshaller.Listener listener) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setListener(listener);
    }

    public void setMarshalCallbacks(HashMap callbacks) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setClassBasedMarshalEvents(callbacks);
    }

    public void setProperty(String key, Object value) throws PropertyException {
        block8: {
            try {
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                if ("jaxb.formatted.output".equals(key)) {
                    Boolean formattedOutput = (Boolean)value;
                    this.xmlMarshaller.setFormattedOutput(formattedOutput);
                    break block8;
                }
                if ("jaxb.encoding".equals(key)) {
                    this.xmlMarshaller.setEncoding((String)value);
                    break block8;
                }
                if ("jaxb.schemaLocation".equals(key)) {
                    this.xmlMarshaller.setSchemaLocation((String)value);
                    break block8;
                }
                if ("jaxb.noNamespaceSchemaLocation".equals(key)) {
                    this.xmlMarshaller.setNoNamespaceSchemaLocation((String)value);
                    break block8;
                }
                if ("jaxb.fragment".equals(key)) {
                    Boolean fragment = (Boolean)value;
                    this.xmlMarshaller.setFragment(fragment);
                    break block8;
                }
                throw new PropertyException(key, value);
            }
            catch (ClassCastException exception) {
                throw new PropertyException(key, (Throwable)exception);
            }
        }
    }

    public void setSchema(Schema schema) {
    }
}

