/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ExclusiveIsolatedClientSession
extends IsolatedClientSession {
    public ExclusiveIsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        super(parent, connectionPolicy);
        this.accessor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if (query.getAccessor() == null) {
            query.setAccessor(this.getAccessor());
        }
        try {
            Object object = query.getAccessor().executeCall(call, translationRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                query.setAccessor(null);
            }
        }
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        AbstractSession executionSession = super.getExecutionSession(query);
        if (executionSession != this) {
            return executionSession;
        }
        if (!this.isActive()) {
            throw ValidationException.excusiveConnectionIsNoLongerAvailable(query, this);
        }
        if (this.getAccessor() == null) {
            this.getParent().acquireClientConnection(this);
        }
        return this;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Accessor getWriteConnection() {
        return this.accessor;
    }

    protected void releaseWriteConnection() {
    }

    public void setWriteConnection(Accessor accessor) {
        this.accessor = accessor;
    }
}

