/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXUnmarshaller
implements PlatformUnmarshaller {
    private static final String VALIDATING = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private int validationMode;
    private Object[] schemas;
    private SAXParser saxParser;
    private XMLReader xmlReader;
    private XMLUnmarshaller xmlUnmarshaller;
    private XMLParser xmlParser;
    private boolean isResultAlwaysXMLRoot;
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public SAXUnmarshaller(XMLUnmarshaller xmlUnmarshaller) throws XMLMarshalException {
        try {
            this.saxParser = saxParserFactory.newSAXParser();
            this.xmlReader = new XMLReader(this.saxParser.getXMLReader());
            this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
            this.xmlParser.setNamespaceAware(true);
            this.xmlParser.setValidationMode(0);
            this.xmlUnmarshaller = xmlUnmarshaller;
        }
        catch (Exception e) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.xmlReader.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.xmlReader.setEntityResolver(entityResolver);
        this.xmlParser.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.xmlReader.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
        this.xmlParser.setErrorHandler(errorHandler);
    }

    public int getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(int validationMode) {
        try {
            this.validationMode = validationMode;
            this.xmlParser.setValidationMode(validationMode);
            switch (validationMode) {
                case 0: {
                    this.xmlReader.setFeature(VALIDATING, false);
                    break;
                }
                case 2: {
                    this.xmlReader.setFeature(VALIDATING, true);
                    break;
                }
                case 3: {
                    try {
                        this.xmlReader.setFeature(VALIDATING, true);
                        this.saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
                        this.saxParser.setProperty(SCHEMA_SOURCE, this.schemas);
                        break;
                    }
                    catch (Exception e) {
                        this.xmlReader.setFeature(VALIDATING, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.xmlParser.setWhitespacePreserving(isWhitespacePreserving);
    }

    public void setSchemas(Object[] schemas) {
        this.schemas = schemas;
    }

    public Object unmarshal(File file) {
        try {
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element domElement = this.xmlParser.parse(file).getDocumentElement();
                return this.unmarshal(domElement);
            }
            FileInputStream inputStream = new FileInputStream(file);
            return this.unmarshal(inputStream);
        }
        catch (FileNotFoundException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(File file, Class clazz) {
        try {
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element domElement = this.xmlParser.parse(file).getDocumentElement();
                return this.unmarshal(domElement, clazz);
            }
            FileInputStream inputStream = new FileInputStream(file);
            return this.unmarshal(inputStream, clazz);
        }
        catch (FileNotFoundException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(InputStream inputStream) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource);
    }

    public Object unmarshal(InputStream inputStream, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource, clazz);
    }

    public Object unmarshal(InputSource inputSource) {
        try {
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (xmlContext.hasDocumentPreservation()) {
                Element domElement = this.xmlParser.parse(inputSource).getDocumentElement();
                return this.unmarshal(domElement);
            }
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(xmlContext);
            saxUnmarshallerHandler.setXMLReader(this.xmlReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(saxUnmarshallerHandler);
            this.xmlReader.parse(inputSource);
            this.xmlReader.setContentHandler(null);
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    public Object unmarshal(InputSource inputSource, XMLReader xmlReader) {
        try {
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            saxUnmarshallerHandler.setXMLReader(xmlReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            xmlReader.setContentHandler(saxUnmarshallerHandler);
            xmlReader.parse(inputSource);
            xmlReader.setContentHandler(null);
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    public Object unmarshal(InputSource inputSource, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
        if (xmlContext.hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(inputSource).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        boolean isPrimitiveWrapper = XMLConversionManager.getDefaultXMLManager().getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            session = xmlContext.getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord();
            unmarshalRecord.setSession(session);
        }
        try {
            unmarshalRecord.setXMLReader(this.xmlReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(unmarshalRecord);
            try {
                this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException ex) {
            }
            catch (SAXNotSupportedException ex) {
                // empty catch block
            }
            this.xmlReader.parse(inputSource);
            this.xmlReader.setContentHandler(null);
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLReader xmlReader) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = XMLConversionManager.getDefaultXMLManager().getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord();
            unmarshalRecord.setSession(session);
        }
        try {
            unmarshalRecord.setXMLReader(xmlReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            xmlReader.setContentHandler(unmarshalRecord);
            try {
                unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException ex) {
            }
            catch (SAXNotSupportedException ex) {
                // empty catch block
            }
            xmlReader.parse(inputSource);
            xmlReader.setContentHandler(null);
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    public Object unmarshal(Node node) {
        DOMReader reader = new DOMReader();
        return this.unmarshal(reader, node);
    }

    public Object unmarshal(DOMReader reader, Node node) {
        try {
            SAXUnmarshallerHandler handler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            reader.setContentHandler(handler);
            handler.setXMLReader(reader);
            handler.setUnmarshaller(this.xmlUnmarshaller);
            reader.parse(node);
            reader.setContentHandler(null);
            handler.resolveReferences();
            return handler.getObject();
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    public Object unmarshal(Node node, Class clazz) {
        DOMReader reader = new DOMReader();
        return this.unmarshal(reader, node, clazz);
    }

    public Object unmarshal(DOMReader domReader, Node node, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = XMLConversionManager.getDefaultXMLManager().getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord();
            unmarshalRecord.setSession(session);
        }
        try {
            unmarshalRecord.setXMLReader(domReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            domReader.setContentHandler(unmarshalRecord);
            domReader.setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            domReader.parse(node);
            domReader.setContentHandler(null);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    public Object unmarshal(Reader reader) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(reader).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource);
    }

    public Object unmarshal(Reader reader, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(reader).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource, clazz);
    }

    public Object unmarshal(Source source) {
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader xmlReader = null;
            if (saxSource.getXMLReader() != null) {
                xmlReader = new XMLReader(saxSource.getXMLReader());
            }
            if (null == xmlReader) {
                return this.unmarshal(saxSource.getInputSource());
            }
            return this.unmarshal(saxSource.getInputSource(), xmlReader);
        }
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            return this.unmarshal(domSource.getNode());
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader());
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream());
            }
            return this.unmarshal(streamSource.getSystemId());
        }
        return null;
    }

    public Object unmarshal(Source source, Class clazz) {
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader xmlReader = null;
            if (saxSource.getXMLReader() == null) {
                xmlReader = new XMLReader(saxSource.getXMLReader());
            }
            if (null == saxSource.getXMLReader()) {
                return this.unmarshal(saxSource.getInputSource(), clazz);
            }
            return this.unmarshal(saxSource.getInputSource(), clazz, xmlReader);
        }
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            return this.unmarshal(domSource.getNode(), clazz);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader(), clazz);
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream(), clazz);
            }
            return this.unmarshal(streamSource.getSystemId(), clazz);
        }
        return null;
    }

    public Object unmarshal(URL url) {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        boolean hasThrownException = false;
        try {
            Object object = this.unmarshal(inputStream);
            return object;
        }
        catch (RuntimeException runtimeException) {
            hasThrownException = true;
            throw runtimeException;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (hasThrownException) break block11;
                    throw XMLMarshalException.unmarshalException(e);
                }
            }
        }
    }

    public Object unmarshal(URL url, Class clazz) {
        try {
            InputStream inputStream = url.openStream();
            Object result = this.unmarshal(inputStream, clazz);
            inputStream.close();
            return result;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(String systemId) {
        try {
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            saxUnmarshallerHandler.setXMLReader(this.xmlReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(saxUnmarshallerHandler);
            this.xmlReader.parse(systemId);
            this.xmlReader.setContentHandler(null);
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    public Object unmarshal(String systemId, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = XMLConversionManager.getDefaultXMLManager().getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord();
            unmarshalRecord.setSession(session);
        }
        try {
            unmarshalRecord.setXMLReader(this.xmlReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(unmarshalRecord);
            try {
                unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException ex) {
            }
            catch (SAXNotSupportedException ex) {
                // empty catch block
            }
            this.xmlReader.parse(systemId);
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    private EclipseLinkException convertSAXException(SAXException saxException) {
        Exception internalException = saxException.getException();
        if (internalException != null) {
            if (EclipseLinkException.class.isAssignableFrom(internalException.getClass())) {
                return (EclipseLinkException)internalException;
            }
            return XMLMarshalException.unmarshalException(internalException);
        }
        return XMLMarshalException.unmarshalException(saxException);
    }

    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }

    static {
        try {
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
        }
    }
}

