/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryAttachmentHandler;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Session;
import org.xml.sax.Attributes;

public class XMLBinaryDataMappingNodeValue
extends NodeValue
implements NullCapableValue {
    private XMLBinaryDataMapping xmlBinaryDataMapping;

    protected String getValueToWrite(QName schemaType, Object value) {
        return (String)XMLConversionManager.getDefaultXMLManager().convertObject(value, ClassConstants.STRING, schemaType);
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.getNextFragment() == null || xPathFragment.getNextFragment().isAttribute();
    }

    public XMLBinaryDataMappingNodeValue(XMLBinaryDataMapping mapping) {
        this.xmlBinaryDataMapping = mapping;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlBinaryDataMapping.isReadOnly()) {
            return false;
        }
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlBinaryDataMapping);
        if (this.xmlBinaryDataMapping.getConverter() != null) {
            Converter converter = this.xmlBinaryDataMapping.getConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(objectValue, session, marshaller) : converter.convertObjectValueToDataValue(objectValue, session);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        if (objectValue == null) {
            return true;
        }
        marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        marshalRecord.closeStartElement();
        if (this.xmlBinaryDataMapping.isSwaRef() && marshaller.getAttachmentMarshaller() != null) {
            String c_id = null;
            if (this.xmlBinaryDataMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = marshaller.getAttachmentMarshaller().addSwaRefAttachment((DataHandler)objectValue);
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataMapping.getMimeType(object));
                byte[] bytes = data.getData();
                c_id = marshaller.getAttachmentMarshaller().addSwaRefAttachment(bytes, 0, bytes.length);
            }
            marshalRecord.characters(c_id);
        } else if (marshaller.getAttachmentMarshaller() != null && marshaller.getAttachmentMarshaller().isXOPPackage() && !this.xmlBinaryDataMapping.shouldInlineBinaryData()) {
            XPathFragment lastFrag = ((XMLField)this.xmlBinaryDataMapping.getField()).getLastXPathFragment();
            String c_id = "";
            if (objectValue.getClass() == ClassConstants.APBYTE) {
                byte[] bytes = (byte[])objectValue;
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, lastFrag.getLocalName(), lastFrag.getNamespaceURI(), null);
            } else if (this.xmlBinaryDataMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment((DataHandler)objectValue, lastFrag.getLocalName(), lastFrag.getNamespaceURI());
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataMapping.getMimeType(object));
                byte[] bytes = data.getData();
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, data.getMimeType(), lastFrag.getLocalName(), lastFrag.getNamespaceURI());
            }
            String xopPrefix = null;
            if (namespaceResolver != null) {
                xopPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
            }
            boolean addDeclaration = false;
            if (xopPrefix == null || namespaceResolver == null) {
                addDeclaration = true;
                xopPrefix = "xop";
                namespaceResolver = new NamespaceResolver();
                namespaceResolver.put(xopPrefix, "http://www.w3.org/2004/08/xop/include");
            }
            XPathFragment xopInclude = new XPathFragment(xopPrefix + ":Include");
            xopInclude.setNamespaceURI("http://www.w3.org/2004/08/xop/include");
            marshalRecord.openStartElement(xopInclude, namespaceResolver);
            marshalRecord.attribute("", "href", "href", c_id);
            if (addDeclaration) {
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", xopPrefix, "xmlns:" + xopPrefix, "http://www.w3.org/2004/08/xop/include");
            }
            marshalRecord.closeStartElement();
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        } else {
            String value = "";
            if (objectValue.getClass() == ClassConstants.ABYTE || objectValue.getClass() == ClassConstants.APBYTE) {
                value = this.getValueToWrite(((XMLField)this.xmlBinaryDataMapping.getField()).getSchemaType(), objectValue);
            } else {
                byte[] bytes = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataMapping.getMimeType(object)).getData();
                value = this.getValueToWrite(((XMLField)this.xmlBinaryDataMapping.getField()).getSchemaType(), bytes);
            }
            marshalRecord.characters(value);
        }
        marshalRecord.endElement(xPathFragment, namespaceResolver);
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        unmarshalRecord.removeNullCapableValue(this);
        XMLField xmlField = (XMLField)this.xmlBinaryDataMapping.getField();
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        if (!(this.xmlBinaryDataMapping.isSwaRef() || this.xmlBinaryDataMapping.shouldInlineBinaryData() || lastFragment.isAttribute())) {
            if (unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller() != null && unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().isXOPPackage()) {
                XMLBinaryAttachmentHandler handler = new XMLBinaryAttachmentHandler(unmarshalRecord, (NodeValue)this, this.xmlBinaryDataMapping);
                unmarshalRecord.getXMLReader().setContentHandler(handler);
            }
        } else if (lastFragment.isAttribute()) {
            String value = atts.getValue(lastFragment.getNamespaceURI(), lastFragment.getLocalName());
            Object fieldValue = null;
            if (this.xmlBinaryDataMapping.isSwaRef()) {
                if (unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller() != null) {
                    fieldValue = this.xmlBinaryDataMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? (Object)unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsDataHandler(value) : unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsByteArray(value);
                    this.xmlBinaryDataMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataMapping.getAttributeClassification()));
                }
            } else {
                fieldValue = XMLConversionManager.getDefaultXMLManager().convertSchemaBase64ToByteArray(value);
                this.xmlBinaryDataMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataMapping.getAttributeClassification()));
            }
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        if (!this.xmlBinaryDataMapping.shouldInlineBinaryData() && !this.xmlBinaryDataMapping.isSwaRef() && unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller() != null && unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().isXOPPackage()) {
            unmarshalRecord.resetStringBuffer();
            return;
        }
        unmarshalRecord.removeNullCapableValue(this);
        Object value = unmarshalRecord.getStringBuffer().toString();
        unmarshalRecord.resetStringBuffer();
        if (this.xmlBinaryDataMapping.isSwaRef() && unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller() != null) {
            value = this.xmlBinaryDataMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsDataHandler((String)value) : (Object)unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsByteArray((String)value);
            if (this.xmlBinaryDataMapping.getConverter() != null) {
                Converter converter = this.xmlBinaryDataMapping.getConverter();
                value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(value, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertDataValueToObjectValue(value, unmarshalRecord.getSession());
            }
        } else {
            value = XMLConversionManager.getDefaultXMLManager().convertSchemaBase64ToByteArray(value);
            if (this.xmlBinaryDataMapping.getConverter() != null) {
                Converter converter = this.xmlBinaryDataMapping.getConverter();
                value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(value, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertDataValueToObjectValue(value, unmarshalRecord.getSession());
            }
        }
        value = XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(value, this.xmlBinaryDataMapping.getAttributeClassification());
        unmarshalRecord.setAttributeValue(value, this.xmlBinaryDataMapping);
    }

    public void setNullValue(Object object, Session session) {
        Object value = this.xmlBinaryDataMapping.getAttributeValue(null, session);
        this.xmlBinaryDataMapping.setAttributeValueInObject(object, value);
    }

    public boolean isNullCapableValue() {
        return true;
    }

    public DataHandler getDataHandlerForObjectValue(Object obj, Class classification) {
        if (classification == DataHandler.class) {
            return (DataHandler)obj;
        }
        return null;
    }
}

