/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util.attrs;

import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.attrs.LocalVariableType;
import org.eclipse.persistence.internal.libraries.asm.attrs.LocalVariableTypeTableAttribute;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMLocalVariableTypeTableAttribute
extends LocalVariableTypeTableAttribute
implements ASMifiable {
    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        LocalVariableTypeTableAttribute localVariableTypeTableAttribute = (LocalVariableTypeTableAttribute)super.read(classReader, n, n2, cArray, n3, labelArray);
        ASMLocalVariableTypeTableAttribute aSMLocalVariableTypeTableAttribute = new ASMLocalVariableTypeTableAttribute();
        aSMLocalVariableTypeTableAttribute.getTypes().addAll(localVariableTypeTableAttribute.getTypes());
        return aSMLocalVariableTypeTableAttribute;
    }

    public void asmify(StringBuffer stringBuffer, String string, Map map) {
        stringBuffer.append("LocalVariableTypeTableAttribute ").append(string).append(" = new LocalVariableTypeTableAttribute();\n");
        stringBuffer.append("{\n");
        stringBuffer.append("LocalVariableTypeTableAttribute ").append(string).append("Attr");
        stringBuffer.append(" = new LocalVariableTypeTableAttribute();\n");
        if (this.types.size() > 0) {
            for (int i = 0; i < this.types.size(); ++i) {
                this.asmify((LocalVariableType)this.types.get(i), stringBuffer, string + "type" + i, map);
            }
        }
        stringBuffer.append(string).append(".visitAttribute(").append(string);
        stringBuffer.append("Attr);\n}\n");
    }

    private void asmify(LocalVariableType localVariableType, StringBuffer stringBuffer, String string, Map map) {
        ASMLocalVariableTypeTableAttribute.declareLabel(stringBuffer, map, localVariableType.start);
        ASMLocalVariableTypeTableAttribute.declareLabel(stringBuffer, map, localVariableType.end);
        stringBuffer.append("{\n");
        stringBuffer.append("LocalVariableType ").append(string).append(" = new LocalVariableType();\n");
        stringBuffer.append(string).append(".start = ").append(map.get(localVariableType.start)).append(";\n");
        stringBuffer.append(string).append(".end = ").append(map.get(localVariableType.end)).append(";\n");
        stringBuffer.append(string).append(".name = \"").append(localVariableType.name).append("\";\n");
        stringBuffer.append(string).append(".signature = ").append(localVariableType.signature).append("\";\n");
        stringBuffer.append(string).append(".index = ").append(localVariableType.index).append("\";\n");
        stringBuffer.append("cvAttr.types.add(").append(string).append(");\n");
        stringBuffer.append("}\n");
    }

    static void declareLabel(StringBuffer stringBuffer, Map map, Label label) {
        String string = (String)map.get(label);
        if (string == null) {
            string = "l" + map.size();
            map.put(label, string);
            stringBuffer.append("Label ").append(string).append(" = new Label();\n");
        }
    }
}

