/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util.attrs;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.Annotation;
import org.eclipse.persistence.internal.libraries.asm.attrs.AnnotationDefaultAttribute;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMAnnotationDefaultAttribute
extends AnnotationDefaultAttribute
implements ASMifiable {
    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        AnnotationDefaultAttribute annotationDefaultAttribute = (AnnotationDefaultAttribute)super.read(classReader, n, n2, cArray, n3, labelArray);
        ASMAnnotationDefaultAttribute aSMAnnotationDefaultAttribute = new ASMAnnotationDefaultAttribute();
        aSMAnnotationDefaultAttribute.defaultValue = annotationDefaultAttribute.defaultValue;
        return aSMAnnotationDefaultAttribute;
    }

    public void asmify(StringBuffer stringBuffer, String string, Map map) {
        stringBuffer.append("AnnotationDefaultAttribute ").append(string).append(" = new AnnotationDefaultAttribute();\n");
        String string2 = ASMAnnotationDefaultAttribute.asmify(this.defaultValue, stringBuffer, string + "Val");
        stringBuffer.append(string).append(".defaultValue = ").append(string2).append(";\n");
    }

    static void asmifyAnnotations(StringBuffer stringBuffer, String string, List list) {
        if (list.size() > 0) {
            stringBuffer.append("{\n");
            for (int i = 0; i < list.size(); ++i) {
                String string2 = string + "ann" + i;
                ASMAnnotationDefaultAttribute.asmify((Annotation)list.get(i), stringBuffer, string2);
                stringBuffer.append(string).append(".annotations.add( ").append(string2).append(");\n");
            }
            stringBuffer.append("}\n");
        }
    }

    static void asmifyParameterAnnotations(StringBuffer stringBuffer, String string, List list) {
        if (list.size() > 0) {
            stringBuffer.append("{\n");
            for (int i = 0; i < list.size(); ++i) {
                String string2 = string + "param" + i;
                stringBuffer.append("List ").append(string2).append(" = new ArrayList();\n");
                List list2 = (List)list.get(i);
                if (list2.size() > 0) {
                    stringBuffer.append("{\n");
                    for (int j = 0; j < list2.size(); ++j) {
                        String string3 = string2 + "ann" + j;
                        ASMAnnotationDefaultAttribute.asmify((Annotation)list2.get(j), stringBuffer, string3);
                        stringBuffer.append(string2).append(".add( ").append(string3).append(");\n");
                    }
                    stringBuffer.append("}\n");
                }
                stringBuffer.append(string).append(".parameters.add( ").append(string2).append(");\n\n");
            }
            stringBuffer.append("}\n");
        }
    }

    static String asmify(Annotation annotation, StringBuffer stringBuffer, String string) {
        stringBuffer.append("Annotation ").append(string).append(" = new Annotation(\"").append(annotation.type).append("\");\n");
        List list = annotation.elementValues;
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                String string2 = ASMAnnotationDefaultAttribute.asmify(objectArray[1], stringBuffer, string + "val" + i);
                stringBuffer.append(string).append(".add( \"").append(objectArray[0]).append("\", ").append(string2).append(");\n");
            }
        }
        return string;
    }

    static String asmify(Object object, StringBuffer stringBuffer, String string) {
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        if (object instanceof Integer) {
            return "new Integer(" + object + ")";
        }
        if (object instanceof Byte) {
            return "new Byte((byte)" + object + ")";
        }
        if (object instanceof Character) {
            return "new Character((char)" + ((Character)object).charValue() + ")";
        }
        if (object instanceof Double) {
            return "new Double(\"" + object + "\")";
        }
        if (object instanceof Float) {
            return "new Float(\"" + object + "\")";
        }
        if (object instanceof Long) {
            return "new Long(" + object + "L)";
        }
        if (object instanceof Short) {
            return "new Short((short)" + object + ")";
        }
        if (object instanceof Boolean) {
            return "new Boolean(" + object + ")";
        }
        if (object instanceof Annotation.EnumConstValue) {
            Annotation.EnumConstValue enumConstValue = (Annotation.EnumConstValue)object;
            return "new Annotation.EnumConstValue(\"" + enumConstValue.typeName + "\", \"" + enumConstValue.constName + "\")";
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return "Type.getType(\"" + type.getDescriptor() + "\")";
        }
        if (object instanceof Annotation) {
            return ASMAnnotationDefaultAttribute.asmify((Annotation)object, stringBuffer, string);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            stringBuffer.append("Object[] ").append(string).append(" = new Object[").append(objectArray.length).append("];\n");
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = ASMAnnotationDefaultAttribute.asmify(objectArray[i], stringBuffer, string + "Arr" + i);
                stringBuffer.append(string + "[" + i + "] = ").append(string2).append(";\n");
            }
            return string;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer2 = new StringBuffer("new byte[] {");
            String string3 = "";
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer2.append(string3).append(byArray[i]);
                string3 = ", ";
            }
            stringBuffer2.append("}");
            return stringBuffer2.toString();
        }
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            StringBuffer stringBuffer3 = new StringBuffer("new char[] {");
            String string4 = "";
            for (int i = 0; i < cArray.length; ++i) {
                stringBuffer3.append(string4).append("(char)").append((int)cArray[i]);
                string4 = ", ";
            }
            stringBuffer3.append("}");
            return stringBuffer3.toString();
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            StringBuffer stringBuffer4 = new StringBuffer("new short[] {");
            String string5 = "";
            for (int i = 0; i < sArray.length; ++i) {
                stringBuffer4.append(string5).append("(short)").append(sArray[i]);
                string5 = ", ";
            }
            stringBuffer4.append("}");
            return stringBuffer4.toString();
        }
        if (object instanceof long[]) {
            long[] lArray = (long[])object;
            StringBuffer stringBuffer5 = new StringBuffer("new long[] {");
            String string6 = "";
            for (int i = 0; i < lArray.length; ++i) {
                stringBuffer5.append(string6).append(lArray[i]).append("L");
                string6 = ", ";
            }
            stringBuffer5.append("}");
            return stringBuffer5.toString();
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            StringBuffer stringBuffer6 = new StringBuffer("new int[] {");
            String string7 = "";
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer6.append(string7).append(nArray[i]);
                string7 = ", ";
            }
            stringBuffer6.append("}");
            return stringBuffer6.toString();
        }
        if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            StringBuffer stringBuffer7 = new StringBuffer("new boolean[] {");
            String string8 = "";
            for (int i = 0; i < blArray.length; ++i) {
                stringBuffer7.append(string8).append(blArray[i]);
                string8 = ", ";
            }
            stringBuffer7.append("}");
            return stringBuffer7.toString();
        }
        if (object instanceof float[]) {
            float[] fArray = (float[])object;
            StringBuffer stringBuffer8 = new StringBuffer("new float[] {");
            String string9 = "";
            for (int i = 0; i < fArray.length; ++i) {
                stringBuffer8.append(string9).append(fArray[i]).append("f");
                string9 = ", ";
            }
            stringBuffer8.append("}");
            return stringBuffer8.toString();
        }
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            StringBuffer stringBuffer9 = new StringBuffer("new double[] {");
            String string10 = "";
            for (int i = 0; i < dArray.length; ++i) {
                stringBuffer9.append(string10).append(dArray[i]).append("d");
                string10 = ", ";
            }
            stringBuffer9.append("}");
            return stringBuffer9.toString();
        }
        throw new IllegalArgumentException("Invalid value: " + object.getClass().getName() + " : " + object);
    }
}

