/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LineNumberNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LocalVariableNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TryCatchBlockNode;

public class MethodNode {
    public int access;
    public String name;
    public String desc;
    public final List exceptions;
    public Attribute attrs;
    public final List instructions;
    public final List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public final List localVariables;
    public final List lineNumbers;
    public Attribute codeAttrs;

    public MethodNode(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        this.access = n;
        this.name = string;
        this.desc = string2;
        this.exceptions = new ArrayList();
        this.instructions = new ArrayList();
        this.tryCatchBlocks = new ArrayList();
        this.localVariables = new ArrayList();
        this.lineNumbers = new ArrayList();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
        this.attrs = attribute;
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        CodeVisitor codeVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, stringArray, this.attrs);
        if (codeVisitor != null && this.instructions.size() > 0) {
            Object object;
            int n;
            for (n = 0; n < this.instructions.size(); ++n) {
                object = this.instructions.get(n);
                if (object instanceof Label) {
                    codeVisitor.visitLabel((Label)object);
                    continue;
                }
                ((AbstractInsnNode)object).accept(codeVisitor);
            }
            for (n = 0; n < this.tryCatchBlocks.size(); ++n) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(n)).accept(codeVisitor);
            }
            codeVisitor.visitMaxs(this.maxStack, this.maxLocals);
            for (n = 0; n < this.localVariables.size(); ++n) {
                ((LocalVariableNode)this.localVariables.get(n)).accept(codeVisitor);
            }
            for (n = 0; n < this.lineNumbers.size(); ++n) {
                ((LineNumberNode)this.lineNumbers.get(n)).accept(codeVisitor);
            }
            object = this.codeAttrs;
            while (object != null) {
                codeVisitor.visitAttribute((Attribute)object);
                object = ((Attribute)object).next;
            }
        }
    }
}

