/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;

public class SerialVersionUIDAdder
extends ClassAdapter {
    protected boolean computeSVUID;
    protected boolean hasSVUID;
    protected long ownSVUID = 0L;
    protected int access;
    protected String className;
    protected String[] interfaces;
    protected Collection svuidFields = new ArrayList();
    protected boolean hasStaticInitializer;
    protected Collection svuidConstructors = new ArrayList();
    protected Collection svuidMethods = new ArrayList();

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        boolean bl = this.computeSVUID = (n2 & 0x200) == 0;
        if (this.computeSVUID) {
            this.className = string;
            this.access = n2;
            this.interfaces = stringArray;
        }
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        if (this.computeSVUID) {
            if (string.equals("<clinit>")) {
                this.hasStaticInitializer = true;
            }
            int n2 = n & 0xD3F;
            if ((n & 2) == 0) {
                if (string.equals("<init>")) {
                    this.svuidConstructors.add(new Item(string, n2, string2));
                } else if (!string.equals("<clinit>")) {
                    this.svuidMethods.add(new Item(string, n2, string2));
                }
            }
        }
        return null;
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        if (this.computeSVUID) {
            if (string.equals("serialVersionUID")) {
                this.computeSVUID = false;
                this.hasSVUID = true;
                this.ownSVUID = (Long)object;
            }
            int n2 = n & 0xDF;
            if ((n & 2) == 0 || (n & 0x88) == 0) {
                this.svuidFields.add(new Item(string, n2, string2));
            }
        }
    }

    public boolean hasSVUID() {
        return this.hasSVUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long computeSVUID() {
        try {
            if (this.hasSVUID) {
                return this.ownSVUID;
            }
            ByteArrayOutputStream byteArrayOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            long l = 0L;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                ((DataOutputStream)filterOutputStream).writeUTF(this.className.replace('/', '.'));
                ((DataOutputStream)filterOutputStream).writeInt(this.access & 0x611);
                Arrays.sort(this.interfaces);
                for (int i = 0; i < this.interfaces.length; ++i) {
                    ((DataOutputStream)filterOutputStream).writeUTF(this.interfaces[i].replace('/', '.'));
                }
                this.writeItems(this.svuidFields, (DataOutputStream)filterOutputStream, false);
                if (this.hasStaticInitializer) {
                    ((DataOutputStream)filterOutputStream).writeUTF("<clinit>");
                    ((DataOutputStream)filterOutputStream).writeInt(8);
                    ((DataOutputStream)filterOutputStream).writeUTF("()V");
                }
                this.writeItems(this.svuidConstructors, (DataOutputStream)filterOutputStream, true);
                this.writeItems(this.svuidMethods, (DataOutputStream)filterOutputStream, true);
                ((DataOutputStream)filterOutputStream).flush();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
                for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                    l = l << 8 | (long)(byArray[i] & 0xFF);
                }
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            return l;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void writeItems(Collection collection, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        int n = collection.size();
        Object[] objectArray = collection.toArray(new Item[n]);
        Arrays.sort(objectArray);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeUTF(((Item)objectArray[i]).name);
            dataOutputStream.writeInt(((Item)objectArray[i]).access);
            dataOutputStream.writeUTF(bl ? ((Item)objectArray[i]).desc.replace('/', '.') : ((Item)objectArray[i]).desc);
        }
    }

    static class Item
    implements Comparable {
        String name;
        int access;
        String desc;

        Item(String string, int n, String string2) {
            this.name = string;
            this.access = n;
            this.desc = string2;
        }

        public int compareTo(Object object) {
            Item item = (Item)object;
            int n = this.name.compareTo(item.name);
            if (n == 0) {
                n = this.desc.compareTo(item.desc);
            }
            return n;
        }
    }
}

