/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.attrs;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.attrs.StackMapFrame;

public class StackMapAttribute
extends Attribute {
    static final int MAX_SIZE = 65535;
    public ArrayList frames = new ArrayList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapFrame getFrame(Label label) {
        for (int i = 0; i < this.frames.size(); ++i) {
            StackMapFrame stackMapFrame = (StackMapFrame)this.frames.get(i);
            if (stackMapFrame.label != label) continue;
            return stackMapFrame;
        }
        return null;
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        StackMapAttribute stackMapAttribute = new StackMapAttribute();
        int n4 = classReader.readInt(n3 + 4);
        int n5 = 0;
        if (n4 > 65535) {
            n5 = classReader.readInt(n);
            n += 4;
        } else {
            n5 = classReader.readShort(n);
            n += 2;
        }
        for (int i = 0; i < n5; ++i) {
            StackMapFrame stackMapFrame = new StackMapFrame();
            n = stackMapFrame.read(classReader, n, cArray, n3, labelArray);
            stackMapAttribute.frames.add(stackMapFrame);
        }
        return stackMapAttribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        ByteVector byteVector = new ByteVector();
        if (byArray != null && byArray.length > 65535) {
            byteVector.putInt(this.frames.size());
        } else {
            byteVector.putShort(this.frames.size());
        }
        for (int i = 0; i < this.frames.size(); ++i) {
            ((StackMapFrame)this.frames.get(i)).write(classWriter, n2, n3, byteVector);
        }
        return byteVector;
    }

    protected Label[] getLabels() {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.frames.size(); ++i) {
            ((StackMapFrame)this.frames.get(i)).getLabels(hashSet);
        }
        return hashSet.toArray(new Label[hashSet.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap[");
        for (int i = 0; i < this.frames.size(); ++i) {
            stringBuffer.append('\n').append('[').append(this.frames.get(i)).append(']');
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

