/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureParameterMetadata {
    private Class m_type;
    private Enum m_direction;
    private Integer m_jdbcType;
    private String m_jdbcTypeName;
    private String m_name;
    private String m_queryParameter;
    private String m_typeName;

    public StoredProcedureParameterMetadata() {
    }

    public StoredProcedureParameterMetadata(Object storedProcedureParameter) {
        this.m_direction = (Enum)MetadataHelper.invokeMethod("procedureParameterDirection", storedProcedureParameter);
        this.m_name = (String)MetadataHelper.invokeMethod("name", storedProcedureParameter);
        this.m_queryParameter = (String)MetadataHelper.invokeMethod("queryParameter", storedProcedureParameter);
        this.m_type = (Class)MetadataHelper.invokeMethod("type", storedProcedureParameter);
        this.m_jdbcType = (Integer)MetadataHelper.invokeMethod("jdbcType", storedProcedureParameter);
        this.m_jdbcTypeName = (String)MetadataHelper.invokeMethod("jdbcTypeName", storedProcedureParameter);
    }

    public Enum getDirection() {
        return this.m_direction;
    }

    public Integer getJdbcType() {
        return this.m_jdbcType;
    }

    public String getJdbcTypeName() {
        return this.m_jdbcTypeName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQueryParameter() {
        return this.m_queryParameter;
    }

    public Class getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    protected boolean hasJdbcType() {
        return this.m_jdbcType != null && this.m_jdbcType.equals(-1);
    }

    protected boolean hasJdbcTypeName() {
        return this.m_jdbcTypeName != null && !this.m_jdbcTypeName.equals("");
    }

    protected boolean hasType() {
        return this.m_type != Void.TYPE;
    }

    public List<String> process(StoredProcedureCall call) {
        String procedureParameterName;
        ArrayList<String> queryArguments = new ArrayList<String>();
        String string = procedureParameterName = this.m_name.equals("") ? this.m_queryParameter : this.m_name;
        if (this.m_direction == null || this.m_direction.equals((Object)Direction.IN)) {
            if (this.hasType()) {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.m_type);
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType);
            } else {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter);
            }
            queryArguments.add(this.m_queryParameter);
        } else if (this.m_direction.equals((Object)Direction.OUT)) {
            if (this.hasType()) {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.m_type);
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType);
            } else {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter);
            }
        } else if (this.m_direction.equals((Object)Direction.IN_OUT)) {
            if (this.hasType()) {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.m_type);
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType);
            } else {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter);
            }
            queryArguments.add(this.m_queryParameter);
        } else if (this.m_direction.equals((Object)Direction.OUT_CURSOR)) {
            call.useNamedCursorOutputAsResultSet(this.m_queryParameter);
        }
        return queryArguments;
    }

    public void setDirection(Enum direction) {
        this.m_direction = direction;
    }

    public void setJdbcType(Integer jdbcType) {
        this.m_jdbcType = jdbcType;
    }

    public void setJdbcTypeName(String jdbcTypeName) {
        this.m_jdbcTypeName = jdbcTypeName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setQueryParameter(String queryParameter) {
        this.m_queryParameter = queryParameter;
    }

    public void setType(Class type) {
        this.m_type = type;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }
}

