/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedStoredProcedureQueryMetadata
extends NamedNativeQueryMetadata {
    private Boolean m_returnsResultSet;
    private List<StoredProcedureParameterMetadata> m_procedureParameters;
    private String m_procedureName;

    public NamedStoredProcedureQueryMetadata() {
        this.setLoadedFromXML();
    }

    public NamedStoredProcedureQueryMetadata(Annotation namedStoredProcedureQuery, String javaClassName) {
        this.setLoadedFromAnnotation();
        this.setLocation(javaClassName);
        this.setName((String)this.invokeMethod("name", namedStoredProcedureQuery));
        this.setHints((Annotation[])this.invokeMethod("hints", namedStoredProcedureQuery));
        this.setResultClass((Class)this.invokeMethod("resultClass", namedStoredProcedureQuery));
        this.setResultSetMapping((String)this.invokeMethod("resultSetMapping", namedStoredProcedureQuery));
        this.setProcedureParameters((Annotation[])this.invokeMethod("procedureParameters", namedStoredProcedureQuery));
        this.m_procedureName = (String)this.invokeMethod("procedureName", namedStoredProcedureQuery);
        this.m_returnsResultSet = (Boolean)this.invokeMethod("returnsResultSet", namedStoredProcedureQuery);
    }

    public String getProcedureName() {
        return this.m_procedureName;
    }

    public List<StoredProcedureParameterMetadata> getProcedureParameters() {
        return this.m_procedureParameters;
    }

    public Boolean getReturnsResultSet() {
        return this.m_returnsResultSet;
    }

    @Override
    public void process(AbstractSession session, ClassLoader loader) {
        StoredProcedureCall call = new StoredProcedureCall();
        ArrayList<String> queryArguments = new ArrayList<String>();
        for (StoredProcedureParameterMetadata parameter : this.m_procedureParameters) {
            queryArguments.addAll(parameter.process(call));
        }
        call.setProcedureName(this.m_procedureName);
        call.setReturnsResultSet(this.m_returnsResultSet == null ? false : this.m_returnsResultSet);
        HashMap<String, String> hints = this.processQueryHints(session);
        if (this.getResultClass() == Void.TYPE) {
            if (this.getResultSetMapping().equals("")) {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(call, queryArguments, hints));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), call, queryArguments, hints));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), loader), call, queryArguments, hints));
        }
    }

    public void setProcedureName(String procedureName) {
        this.m_procedureName = procedureName;
    }

    public void setProcedureParameters(Annotation[] procedureParameters) {
        this.m_procedureParameters = new ArrayList<StoredProcedureParameterMetadata>();
        for (Annotation storedProcedureParameter : procedureParameters) {
            this.m_procedureParameters.add(new StoredProcedureParameterMetadata(storedProcedureParameter));
        }
    }

    public void setProcedureParameters(List<StoredProcedureParameterMetadata> procedureParameters) {
        this.m_procedureParameters = procedureParameters;
    }

    public void setReturnsResultSet(Boolean returnsResultSet) {
        this.m_returnsResultSet = returnsResultSet;
    }
}

