/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class TypeConverterMetadata
extends AbstractConverterMetadata {
    private Class m_dataType;
    private Class m_objectType;
    private String m_dataTypeName;
    private String m_objectTypeName;

    public TypeConverterMetadata() {
        this.setLoadedFromXML();
    }

    public TypeConverterMetadata(Annotation typeConverter, AnnotatedElement annotatedElement) {
        this.setLoadedFromAnnotation();
        this.setLocation(annotatedElement.toString());
        this.setName((String)this.invokeMethod("name", typeConverter));
        this.m_dataType = (Class)this.invokeMethod("dataType", typeConverter);
        this.m_objectType = (Class)this.invokeMethod("objectType", typeConverter);
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TypeConverterMetadata) {
            TypeConverterMetadata typeConverter = (TypeConverterMetadata)objectToCompare;
            if (!MetadataHelper.valuesMatch(this.getName(), typeConverter.getName())) {
                return false;
            }
            if (!MetadataHelper.valuesMatch(this.m_dataType, typeConverter.getDataType())) {
                return false;
            }
            return MetadataHelper.valuesMatch(this.m_objectType, typeConverter.getObjectType());
        }
        return false;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public Class getDataType(DirectAccessor accessor) {
        if (this.m_dataType == Void.TYPE) {
            Class dataType = accessor.getReferenceClass();
            if (dataType == null) {
                throw ValidationException.noConverterDataTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName(), this.getName());
            }
            accessor.getLogger().logConfigMessage("metadata_default_converter_data_type", accessor, this.getName(), dataType);
            return dataType;
        }
        return this.m_dataType;
    }

    public String getDataTypeName() {
        return this.m_dataTypeName;
    }

    public Class getObjectType(DirectAccessor accessor) {
        if (this.m_objectType == Void.TYPE) {
            Class objectType = accessor.getReferenceClass();
            if (objectType == null) {
                throw ValidationException.noConverterObjectTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName(), this.getName());
            }
            accessor.getLogger().logConfigMessage("metadata_default_converter_object_type", accessor, this.getName(), objectType);
            return objectType;
        }
        return this.m_objectType;
    }

    public Class getObjectType() {
        return this.m_objectType;
    }

    public String getObjectTypeName() {
        return this.m_objectTypeName;
    }

    public void process(DatabaseMapping mapping, DirectAccessor accessor) {
        TypeConversionConverter converter = new TypeConversionConverter(mapping);
        converter.setDataClassName(this.getDataType(accessor).getName());
        converter.setObjectClassName(this.getObjectType(accessor).getName());
        accessor.setConverter(mapping, converter);
        accessor.setFieldClassification(mapping, this.m_dataType);
    }

    public void setDataType(Class dataType) {
        this.m_dataType = dataType;
    }

    public void setDataTypeName(String dataTypeName) {
        this.m_dataTypeName = dataTypeName;
    }

    public void setObjectType(Class objectType) {
        this.m_objectType = objectType;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.m_objectTypeName = objectTypeName;
    }
}

