/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;

public abstract class MetadataAccessibleObject {
    private String m_name;
    private Class m_rawClass;
    private Type m_relationType;
    private String m_attributeName;
    private AnnotatedElement m_annotatedElement;
    private HashMap m_annotations;

    public MetadataAccessibleObject(AnnotatedElement annotatedElement) {
        this.setAnnotatedElement(annotatedElement);
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    public HashMap getAnnotations() {
        return this.m_annotations;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public Class getMapKeyClass() {
        if (MetadataHelper.isGenericCollectionType(this.m_relationType)) {
            return MetadataHelper.getMapKeyTypeFromGeneric(this.m_relationType);
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public Class getRawClass() {
        if (this.m_rawClass == null) {
            this.m_rawClass = MetadataHelper.isGenericCollectionType(this.m_relationType) ? MetadataHelper.getRawClassFromGeneric(this.m_relationType) : (Class)this.m_relationType;
        }
        return this.m_rawClass;
    }

    public Class getReferenceClassFromGeneric() {
        if (MetadataHelper.isGenericCollectionType(this.m_relationType)) {
            return MetadataHelper.getReturnTypeFromGeneric(this.m_relationType);
        }
        return null;
    }

    public Type getRelationType() {
        return this.m_relationType;
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.m_annotatedElement = annotatedElement;
        this.m_annotations = new HashMap();
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            String annotationName = ((Object)annotation).toString().substring(1, ((Object)annotation).toString().indexOf("("));
            this.m_annotations.put(annotationName, annotation);
        }
    }

    protected void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    protected void setRelationType(Type relationType) {
        this.m_relationType = relationType;
    }
}

