/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.CascadeTypes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnsMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MetadataAccessor {
    private boolean m_privateOwned;
    private CascadeTypes m_cascadeTypes;
    protected Class m_referenceClass;
    private Class m_targetEntity;
    private Enum m_fetch;
    private Enum m_joinFetch;
    private List<JoinColumnMetadata> m_joinColumns;
    private String m_mappedBy;
    private String m_targetEntityName;

    protected RelationshipAccessor() {
    }

    protected RelationshipAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    public CascadeTypes getCascadeTypes() {
        return this.m_cascadeTypes;
    }

    @Override
    public abstract Enum getDefaultFetchType();

    public Enum getFetch() {
        return this.m_fetch;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    protected abstract String getLoggingContext();

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    protected DatabaseMapping getOwningMapping() {
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = ownerDescriptor.getMappingForAttributeName(this.getMappedBy(), this);
        if (mapping == null) {
            throw ValidationException.noMappedByAttributeFound(ownerDescriptor.getJavaClass(), this.getMappedBy(), this.getJavaClass(), this.getAttributeName());
        }
        return mapping;
    }

    public String getPrivateOwned() {
        return null;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor descriptor;
        try {
            descriptor = super.getReferenceDescriptor();
        }
        catch (Exception exception) {
            descriptor = null;
        }
        if (descriptor == null || descriptor.isEmbeddable() || descriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship(this.getJavaClass(), this.getReferenceClass(), this.getAnnotatedElement());
        }
        return descriptor;
    }

    public Class getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    public boolean hasJoinColumn() {
        return this.isAnnotationPresent(JoinColumn.class);
    }

    public boolean hasJoinColumns() {
        return this.isAnnotationPresent(JoinColumns.class);
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        if (this.getPrimaryKeyJoinColumns() != null && !this.getPrimaryKeyJoinColumns().isEmpty()) {
            return true;
        }
        return this.isAnnotationPresent(PrimaryKeyJoinColumns.class) || this.isAnnotationPresent(PrimaryKeyJoinColumn.class);
    }

    protected boolean hasPrivateOwned() {
        return this.m_privateOwned || this.isAnnotationPresent(PrivateOwned.class);
    }

    @Override
    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        if (this.getTargetEntityName() != null) {
            this.setTargetEntity(this.getEntityMappings().getClassForName(this.getTargetEntityName()));
        } else {
            this.setTargetEntity(Void.TYPE);
        }
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && this.hasPrimaryKeyJoinColumns();
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned;
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        if (this.m_cascadeTypes != null) {
            for (Enum cascadeType : this.m_cascadeTypes.getTypes()) {
                this.setCascadeType(cascadeType, mapping);
            }
        }
        if (this.getDescriptor().isCascadePersist() && !mapping.isCascadePersist()) {
            this.setCascadeType((Enum)CascadeType.PERSIST, mapping);
        }
    }

    protected List<JoinColumnMetadata> processJoinColumns() {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.processJoinColumns(new JoinColumnsMetadata(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns()), this.getReferenceDescriptor());
        }
        if (this.m_joinColumns == null || this.m_joinColumns.isEmpty()) {
            Object joinColumn = this.getAnnotation(JoinColumn.class);
            Object joinColumns = this.getAnnotation(JoinColumns.class);
            return this.processJoinColumns(new JoinColumnsMetadata((Annotation)joinColumns, (Annotation)joinColumn), this.getReferenceDescriptor());
        }
        return this.processJoinColumns(new JoinColumnsMetadata(this.m_joinColumns), this.getReferenceDescriptor());
    }

    protected List<JoinColumnMetadata> processJoinColumns(JoinColumnsMetadata joinColumns, MetadataDescriptor descriptor) {
        List<JoinColumnMetadata> jColumns = joinColumns.values(descriptor);
        if (descriptor.hasCompositePrimaryKey()) {
            if (jColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
            for (JoinColumnMetadata jColumn : jColumns) {
                if (!jColumn.isPrimaryKeyFieldNotSpecified() && !jColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
        } else if (jColumns.size() > 1) {
            throw ValidationException.excessiveJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
        }
        return jColumns;
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.getDescriptor().hasMappingForAttributeName(this.getAttributeName())) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapping", this);
            } else {
                if (this.hasColumn()) {
                    throw ValidationException.invalidColumnAnnotationOnRelationship(this.getJavaClass(), this.getAttributeName());
                }
                if (this.hasConvert()) {
                    throw ValidationException.invalidMappingForConverter(this.getJavaClass(), this.getAttributeName());
                }
                if (!(this.getTargetEntity() == ValueHolderInterface.class || this.getTargetEntity() == Void.TYPE && this.getReferenceClass().getName().equalsIgnoreCase(ValueHolderInterface.class.getName()))) {
                    this.process();
                }
            }
            this.setIsProcessed();
        }
    }

    protected void setCascadeType(Enum type, ForeignReferenceMapping mapping) {
        if (type.equals(CascadeType.ALL)) {
            mapping.setCascadeAll(true);
        } else if (type.equals(CascadeType.MERGE)) {
            mapping.setCascadeMerge(true);
        } else if (type.equals(CascadeType.PERSIST)) {
            mapping.setCascadePersist(true);
        } else if (type.equals(CascadeType.REFRESH)) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals(CascadeType.REMOVE)) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setCascadeTypes(Enum[] cascadeTypes) {
        this.m_cascadeTypes = new CascadeTypes(cascadeTypes);
    }

    public void setCascadeTypes(CascadeTypes cascadeTypes) {
        this.m_cascadeTypes = cascadeTypes;
    }

    public void setFetch(Enum fetch) {
        this.m_fetch = fetch;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinFetch(Enum joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }

    public void setPrivateOwned(String ignore) {
        this.m_privateOwned = true;
    }

    public void setTargetEntity(Class targetEntity) {
        this.m_targetEntity = targetEntity;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.m_targetEntityName = targetEntityName;
    }

    public boolean usesIndirection() {
        Enum fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY);
    }
}

