/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import javax.persistence.ManyToMany;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.ManyToManyMapping;

public class ManyToManyAccessor
extends CollectionAccessor {
    public ManyToManyAccessor() {
    }

    public ManyToManyAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object manyToMany = this.getAnnotation(ManyToMany.class);
        this.setTargetEntity((Class)this.invokeMethod("targetEntity", manyToMany));
        this.setCascadeTypes((Enum[])this.invokeMethod("cascade", manyToMany));
        this.setFetch((Enum)this.invokeMethod("fetch", manyToMany));
        this.setMappedBy((String)this.invokeMethod("mappedBy", manyToMany));
    }

    protected String getLoggingContext() {
        return "metadata_default_many_to_many_reference_class";
    }

    protected boolean hasPrivateOwned() {
        if (super.hasPrivateOwned()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_private_owned", this);
        }
        return false;
    }

    public boolean isManyToMany() {
        return true;
    }

    public void process() {
        super.process();
        ManyToManyMapping mapping = new ManyToManyMapping();
        this.process(mapping);
        if (this.getMappedBy().equals("")) {
            this.processJoinTable(mapping);
        } else {
            mapping.setIsReadOnly(true);
            ManyToManyMapping ownerMapping = null;
            if (!this.getOwningMapping().isManyToManyMapping()) {
                throw ValidationException.invalidMapping(this.getJavaClass(), this.getReferenceClass());
            }
            ownerMapping = (ManyToManyMapping)this.getOwningMapping();
            mapping.setRelationTable(ownerMapping.getRelationTable());
            mapping.setSourceKeyFields(ownerMapping.getTargetKeyFields());
            mapping.setSourceRelationKeyFields(ownerMapping.getTargetRelationKeyFields());
            mapping.setTargetKeyFields(ownerMapping.getSourceKeyFields());
            mapping.setTargetRelationKeyFields(ownerMapping.getSourceRelationKeyFields());
        }
        this.getDescriptor().addMapping(mapping);
    }
}

