/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EmbeddedIdAccessor
extends EmbeddedAccessor {
    protected HashMap<String, DatabaseField> m_idFields = new HashMap();

    public EmbeddedIdAccessor() {
    }

    public EmbeddedIdAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    public boolean isEmbeddedId() {
        return true;
    }

    public void process() {
        if (this.getDescriptor().hasEmbeddedIdAttribute()) {
            throw ValidationException.multipleEmbeddedIdAnnotationsFound(this.getJavaClass(), this.getAttributeName(), this.getDescriptor().getEmbeddedIdAttributeName());
        }
        if (this.getDescriptor().hasPrimaryKeyFields()) {
            throw ValidationException.embeddedIdAndIdAnnotationFound(this.getJavaClass(), this.getAttributeName(), this.getDescriptor().getIdAttributeName());
        }
        this.getDescriptor().setPKClass(this.getReferenceClass());
        this.getDescriptor().setEmbeddedIdAttributeName(this.getAttributeName());
        super.process();
        for (DatabaseField field : this.m_idFields.values()) {
            this.getDescriptor().addPrimaryKeyField(field);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping mapping, ColumnMetadata column) {
        super.processAttributeOverride(mapping, column);
        DatabaseField field = column.getDatabaseField();
        field.setTable(this.getDescriptor().getPrimaryTable());
        this.m_idFields.put(column.getAttributeName(), field);
    }

    protected MetadataDescriptor processEmbeddableClass() {
        MetadataDescriptor embeddableDescriptor = super.processEmbeddableClass();
        if (this.isEmbeddedId()) {
            if (embeddableDescriptor.getMappings().isEmpty()) {
                String accessType = embeddableDescriptor.usesPropertyAccess() ? EmbeddedAccessor.AccessType.PROPERTY.name() : EmbeddedAccessor.AccessType.FIELD.name();
                throw ValidationException.embeddedIdHasNoAttributes(this.getDescriptor().getJavaClass(), embeddableDescriptor.getJavaClass(), accessType);
            }
            for (DatabaseMapping mapping : embeddableDescriptor.getMappings()) {
                DatabaseField field = (DatabaseField)mapping.getField().clone();
                field.setTable(this.getDescriptor().getPrimaryTable());
                this.m_idFields.put(mapping.getAttributeName(), field);
            }
        }
        return embeddableDescriptor;
    }
}

