/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Embeddable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedAccessor
extends MetadataAccessor {
    private boolean m_loadedFromAnnotations;
    private List<AttributeOverrideMetadata> m_attributeOverrides;

    public EmbeddedAccessor() {
        this.m_loadedFromAnnotations = false;
    }

    public EmbeddedAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        this.m_loadedFromAnnotations = true;
    }

    protected AccessType computeAccessTypeFromAnnotation(MetadataDescriptor descriptor) {
        boolean fieldAccess = MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getFields(descriptor.getJavaClass()));
        boolean propertyAccess = MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getMethods(descriptor.getJavaClass()));
        if (fieldAccess && propertyAccess) {
            return AccessType.MIXED;
        }
        if (fieldAccess) {
            return AccessType.FIELD;
        }
        if (propertyAccess) {
            return AccessType.PROPERTY;
        }
        return AccessType.UNDEFINED;
    }

    protected AccessType determineAccessTypeOfEmbedded(MetadataDescriptor descriptor) {
        AccessType xmlAccessType;
        AccessType accessType = AccessType.UNDEFINED;
        AccessType entityAccessType = this.getDescriptor().usesPropertyAccess() ? AccessType.PROPERTY : AccessType.FIELD;
        AccessType accessType2 = xmlAccessType = descriptor.getXMLAccess() == null ? AccessType.UNDEFINED : AccessType.valueOf(descriptor.getXMLAccess());
        if (descriptor.ignoreAnnotations()) {
            accessType = xmlAccessType == AccessType.UNDEFINED ? entityAccessType : xmlAccessType;
        } else {
            AccessType annotationAccessType = this.computeAccessTypeFromAnnotation(descriptor);
            if (annotationAccessType == AccessType.UNDEFINED && xmlAccessType == AccessType.UNDEFINED) {
                accessType = entityAccessType;
            } else if (xmlAccessType == AccessType.UNDEFINED && annotationAccessType != AccessType.UNDEFINED) {
                accessType = annotationAccessType;
                if (accessType == AccessType.MIXED) {
                    throw ValidationException.bothFieldsAndPropertiesAnnotated(descriptor.getJavaClass());
                }
            } else if (annotationAccessType == AccessType.UNDEFINED && xmlAccessType != AccessType.UNDEFINED) {
                accessType = xmlAccessType;
            } else if (annotationAccessType == xmlAccessType) {
                accessType = annotationAccessType;
            } else {
                throw ValidationException.incorrectOverridingOfAccessType(descriptor.getJavaClass(), xmlAccessType.toString(), annotationAccessType.toString());
            }
        }
        return accessType;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    protected boolean isMetadataPresent(MetadataDescriptor descriptor) {
        AccessType annotAccessType = this.computeAccessTypeFromAnnotation(descriptor);
        AccessType xmlAccessType = descriptor.getXMLAccess() == null ? AccessType.UNDEFINED : AccessType.valueOf(descriptor.getXMLAccess());
        return annotAccessType != AccessType.UNDEFINED || xmlAccessType != AccessType.UNDEFINED;
    }

    @Override
    public void process() {
        this.processReturnInsertAndUpdate();
        MetadataDescriptor referenceDescriptor = this.processEmbeddableClass();
        this.getDescriptor().addAggregateDescriptor(referenceDescriptor);
        if (this.getDescriptor().hasMappingForAttributeName(this.getAttributeName())) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_mapping", this.getDescriptor(), this);
        } else {
            AggregateObjectMapping mapping = new AggregateObjectMapping();
            mapping.setIsReadOnly(false);
            mapping.setIsNullAllowed(true);
            mapping.setReferenceClassName(this.getReferenceClassName());
            mapping.setAttributeName(this.getAttributeName());
            this.setAccessorMethods(mapping);
            this.processAttributeOverrides(mapping);
            this.processAssociationOverrides(mapping);
            this.getDescriptor().addMapping(mapping);
        }
    }

    protected void processAssociationOverride(Object associationOverride, AggregateObjectMapping aggregateMapping) {
        String name;
        MetadataDescriptor aggregateDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = aggregateDescriptor.getMappingForAttributeName(name = (String)this.invokeMethod("name", associationOverride));
        if (mapping != null && mapping.isOneToOneMapping()) {
            int index = 0;
            for (Object joinColumn : (Object[])this.invokeMethod("joinColumns", associationOverride)) {
                DatabaseField fkField = ((OneToOneMapping)mapping).getForeignKeyFields().elementAt(index++);
                aggregateMapping.addFieldNameTranslation((String)this.invokeMethod("name", joinColumn), fkField.getName());
            }
        }
    }

    protected void processAssociationOverrides(AggregateObjectMapping mapping) {
        Object associationOverride;
        Object associationOverrides = this.getAnnotation(AssociationOverrides.class);
        if (associationOverrides != null) {
            for (Object associationOverride2 : (Object[])this.invokeMethod("value", associationOverrides)) {
                this.processAssociationOverride(associationOverride2, mapping);
            }
        }
        if ((associationOverride = this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(associationOverride, mapping);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping mapping, ColumnMetadata column) {
        String attributeName = column.getAttributeName();
        DatabaseMapping aggregateMapping = this.getReferenceDescriptor().getMappingForAttributeName(attributeName);
        if (aggregateMapping == null) {
            throw ValidationException.invalidEmbeddableAttribute(this.getReferenceDescriptor().getJavaClass(), attributeName, this.getJavaClass(), mapping.getAttributeName());
        }
        if (this.getDescriptor().hasAttributeOverrideFor(attributeName)) {
            column.setDatabaseField(this.getDescriptor().getAttributeOverrideFor(attributeName).getColumn().getDatabaseField());
        }
        mapping.addFieldNameTranslation(column.getDatabaseField().getQualifiedName(), aggregateMapping.getField().getName());
    }

    protected void processAttributeOverrides(AggregateObjectMapping mapping) {
        if (this.m_attributeOverrides != null) {
            for (AttributeOverrideMetadata attributeOverride : this.m_attributeOverrides) {
                ColumnMetadata overrideColumn = attributeOverride.getColumn();
                overrideColumn.setAttributeName(attributeOverride.getName());
                this.processAttributeOverride(mapping, overrideColumn);
            }
        } else if (this.m_loadedFromAnnotations) {
            Object attributeOverride;
            Object attributeOverrides = this.getAnnotation(AttributeOverrides.class);
            if (attributeOverrides != null) {
                for (Annotation attributeOverride2 : (Annotation[])this.invokeMethod("value", attributeOverrides)) {
                    this.processAttributeOverride(mapping, new ColumnMetadata((Annotation)this.invokeMethod("column", attributeOverride2), (String)this.invokeMethod("name", attributeOverride2)));
                }
            }
            if ((attributeOverride = this.getAnnotation(AttributeOverride.class)) != null) {
                this.processAttributeOverride(mapping, new ColumnMetadata((Annotation)this.invokeMethod("column", attributeOverride), (String)this.invokeMethod("name", attributeOverride)));
            }
        }
    }

    protected MetadataDescriptor processEmbeddableClass() {
        EmbeddableAccessor embeddableAccessor = this.getProject().getEmbeddableAccessor(this.getReferenceClassName());
        if (embeddableAccessor == null) {
            if (MetadataHelper.isAnnotationNotPresent(Embeddable.class, this.getReferenceClass())) {
                throw ValidationException.invalidEmbeddedAttribute(this.getJavaClass(), this.getAttributeName(), this.getReferenceClass());
            }
            embeddableAccessor = new EmbeddableAccessor(this.getReferenceClass(), this.getProject());
            this.getProject().addEmbeddableAccessor(embeddableAccessor);
        }
        MetadataDescriptor embeddableDescriptor = embeddableAccessor.getDescriptor();
        if (!embeddableAccessor.isProcessed()) {
            AccessType accessType = this.determineAccessTypeOfEmbedded(embeddableDescriptor);
            embeddableDescriptor.setUsesPropertyAccess(accessType == AccessType.PROPERTY);
            embeddableAccessor.process();
            embeddableAccessor.setIsProcessed();
        }
        if (!this.isMetadataPresent(embeddableDescriptor) && embeddableDescriptor.usesPropertyAccess() != this.getDescriptor().usesPropertyAccess()) {
            throw ValidationException.conflictingAccessTypeForEmbeddable(embeddableDescriptor.getJavaClass());
        }
        return embeddableDescriptor;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AccessType {
        FIELD,
        PROPERTY,
        UNDEFINED,
        MIXED;

    }
}

