/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.NonRelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public abstract class DirectAccessor
extends NonRelationshipAccessor {
    private static final String CONVERT_NONE = "none";
    private static final String CONVERT_SERIALIZED = "serialized";
    private static final String DEFAULT_MAP_KEY_COLUMN_SUFFIX = "_KEY";
    private Enum m_fetch;
    private Boolean m_optional;
    private Boolean m_lob;
    private Enum m_enumerated;
    private String m_convert;
    private Enum m_temporal;

    protected DirectAccessor() {
    }

    protected DirectAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected abstract ColumnMetadata getColumn(String var1);

    public String getConvert() {
        return this.m_convert;
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        ColumnMetadata column = this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName()) && !loggingCtx.equals("metadata_default_key_column") ? this.getDescriptor().getAttributeOverrideFor(this.getAttributeName()).getColumn() : this.getColumn(loggingCtx);
        DatabaseField field = column.getDatabaseField();
        if (field.getTableName().equals("")) {
            field.setTable(defaultTable);
        }
        String defaultName = column.getUpperCaseAttributeName();
        if (loggingCtx.equals("metadata_default_key_column")) {
            defaultName = defaultName + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        }
        field.setName(this.getName(field.getName(), defaultName, loggingCtx));
        return field;
    }

    public abstract FetchType getDefaultFetchType();

    public Enum getEnumerated() {
        return this.m_enumerated;
    }

    public Enum getFetch() {
        return this.m_fetch;
    }

    public Boolean getLob() {
        return this.m_lob;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public Enum getTemporal() {
        return this.m_temporal;
    }

    protected boolean hasConvert() {
        return this.m_convert != null || this.isAnnotationPresent(Convert.class);
    }

    public boolean hasEnumerated() {
        return this.m_enumerated != null || this.isAnnotationPresent(Enumerated.class);
    }

    public boolean hasLob() {
        return this.m_lob != null || this.isAnnotationPresent(Lob.class);
    }

    public boolean hasTemporal() {
        return this.m_temporal != null || this.isAnnotationPresent(Temporal.class);
    }

    public boolean isEnumerated() {
        if (this.hasConvert()) {
            if (this.hasEnumerated()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_enumerated", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasEnumerated() || MetadataHelper.isValidEnumeratedType(this.getReferenceClass());
    }

    public boolean isLob() {
        if (this.hasConvert()) {
            if (this.hasLob()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_lob", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasLob();
    }

    public boolean isOptional() {
        if (this.m_optional == null) {
            return true;
        }
        return this.m_optional;
    }

    public boolean isSerialized() {
        if (this.hasConvert()) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_serialized", this.getJavaClass(), this.getAnnotatedElement());
            return false;
        }
        return MetadataHelper.isValidSerializedType(this.getReferenceClass());
    }

    public boolean isTemporal() {
        if (this.hasConvert()) {
            if (this.hasTemporal()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_temporal", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasTemporal() || MetadataHelper.isValidTemporalType(this.getReferenceClass());
    }

    public void processConvert() {
        Object convert = this.getAnnotation(Convert.class);
        String convertValue = this.m_convert == null ? (String)this.invokeMethod("value", convert) : this.m_convert;
        this.processConvert(this.getDescriptor().getMappingForAttributeName(this.getAttributeName()), convertValue);
    }

    protected void processConvert(DatabaseMapping mapping, String converterName) {
        if (!converterName.equals(CONVERT_NONE)) {
            if (converterName.equals(CONVERT_SERIALIZED)) {
                this.processSerialized(mapping);
            } else {
                AbstractConverterMetadata converter = this.getProject().getConverter(converterName);
                if (converter == null) {
                    StructConverterMetadata structConverter = this.getProject().getStructConverter(converterName);
                    if (structConverter == null) {
                        throw ValidationException.converterNotFound(this.getJavaClass(), converterName, this.getAnnotatedElement());
                    }
                    structConverter.process(mapping, this);
                } else {
                    converter.process(mapping, this);
                }
            }
        }
    }

    protected void processEnumerated(DatabaseMapping mapping) {
        Object enumerated;
        if (this.hasEnumerated() && !MetadataHelper.isValidEnumeratedType(this.getReferenceClass())) {
            throw ValidationException.invalidTypeForEnumeratedAttribute(mapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        Object enumType = this.m_enumerated == null ? ((enumerated = this.getAnnotation(Enumerated.class)) == null ? EnumType.ORDINAL : (Enum)this.invokeMethod("value", enumerated)) : this.m_enumerated;
        this.setConverter(mapping, new EnumTypeConverter(mapping, this.getReferenceClass(), ((Enum)enumType).equals(EnumType.ORDINAL)));
    }

    protected void processJPAConverters(DatabaseMapping mapping) {
        if (this.isEnumerated()) {
            this.processEnumerated(mapping);
        } else if (this.isLob()) {
            this.processLob(mapping);
        } else if (this.isTemporal()) {
            this.processTemporal(mapping);
        } else if (this.isSerialized()) {
            this.processSerialized(mapping);
        }
    }

    protected void processLob(DatabaseMapping mapping) {
        if (MetadataHelper.isValidClobType(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Clob.class);
            this.setConverter(mapping, new TypeConversionConverter(mapping));
        } else if (MetadataHelper.isValidBlobType(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Blob.class);
            this.setConverter(mapping, new TypeConversionConverter(mapping));
        } else if (Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            this.setFieldClassification(mapping, Blob.class);
            this.setConverter(mapping, new SerializedObjectConverter(mapping));
        } else {
            throw ValidationException.invalidTypeForLOBAttribute(mapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
    }

    protected void processMappingConverter(DatabaseMapping mapping) {
        if (this.m_convert == null) {
            Object convert = this.getAnnotation(Convert.class);
            if (convert == null) {
                this.processJPAConverters(mapping);
            } else {
                this.processMappingConverter(mapping, (String)this.invokeMethod("value", convert));
            }
        } else {
            this.processMappingConverter(mapping, this.m_convert);
        }
    }

    protected void processMappingConverter(DatabaseMapping mapping, String convertValue) {
        if (convertValue != null && !convertValue.equals(CONVERT_NONE)) {
            this.getProject().addConvertAccessor(this);
        }
        this.processJPAConverters(mapping);
    }

    protected void processSerialized(DatabaseMapping mapping) {
        if (!Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            throw ValidationException.invalidTypeForSerializedAttribute(mapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        SerializedObjectConverter converter = new SerializedObjectConverter(mapping);
        this.setConverter(mapping, converter);
    }

    protected void processTemporal(DatabaseMapping mapping) {
        Enum temporalType = null;
        if (this.m_temporal == null) {
            Object temporal = this.getAnnotation(Temporal.class);
            if (temporal != null) {
                temporalType = (Enum)this.invokeMethod("value", temporal);
            }
        } else {
            temporalType = this.m_temporal;
        }
        if (temporalType == null) {
            throw ValidationException.noTemporalTypeSpecified(this.getAttributeName(), this.getJavaClass());
        }
        if (!MetadataHelper.isValidTemporalType(this.getReferenceClass())) {
            throw ValidationException.invalidTypeForTemporalAttribute(this.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        this.setFieldClassification(mapping, MetadataHelper.getFieldClassification(temporalType));
        this.setConverter(mapping, new TypeConversionConverter(mapping));
    }

    public void setConvert(String convert) {
        this.m_convert = convert;
    }

    public abstract void setConverter(DatabaseMapping var1, Converter var2);

    public abstract void setConverterClassName(DatabaseMapping var1, String var2);

    public void setEnumerated(Enum enumerated) {
        this.m_enumerated = enumerated;
    }

    public void setFetch(Enum fetch) {
        this.m_fetch = fetch;
    }

    public abstract void setFieldClassification(DatabaseMapping var1, Class var2);

    public void setLob(Boolean lob) {
        this.m_lob = lob;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }

    public void setTemporal(Enum temporalType) {
        this.m_temporal = temporalType;
    }

    public boolean usesIndirection() {
        Enum fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY);
    }
}

