/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ImmutableIntShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortIntMap;
import org.eclipse.collections.api.map.primitive.IntShortMap;
import org.eclipse.collections.api.map.primitive.MutableIntShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.IntShortPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntShortProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.factory.primitive.ShortIntMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.map.mutable.primitive.IntShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

final class ImmutableIntShortHashMap
implements ImmutableIntShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntShortMap delegate;

    ImmutableIntShortHashMap(IntShortMap delegate) {
        this.delegate = new IntShortHashMap(delegate);
    }

    public short get(int key) {
        return this.delegate.get(key);
    }

    public short getIfAbsent(int key, short ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(short value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(IntShortProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<IntShortPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableShortIntMap flipUniqueValues() {
        MutableShortIntMap result = ShortIntMaps.mutable.empty();
        this.forEachKeyValue((IntShortProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableIntShortMap select(IntShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntShortMap reject(IntShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableShortIterator iterator = this.delegate.shortIterator();
            while (iterator.hasNext()) {
                MutableShortBag batch = ShortBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableIntShortMap toImmutable() {
        return this;
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)this.delegate.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableShortBag select(ShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortBag reject(ShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public short max() {
        return this.delegate.max();
    }

    public short maxIfEmpty(short defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public short min() {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableShortList toSortedList() {
        return this.delegate.toSortedList();
    }

    public short[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(short value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList() {
        return this.delegate.toList();
    }

    public MutableShortSet toSet() {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag() {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableIntShortMap newWithKeyValue(int key, short value) {
        IntShortHashMap map = new IntShortHashMap(this.size() + 1);
        map.putAll((IntShortMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableIntShortMap newWithoutKey(int key) {
        IntShortHashMap map = new IntShortHashMap(this.size());
        map.putAll((IntShortMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableIntShortMap newWithoutAllKeys(IntIterable keys) {
        IntShortHashMap map = new IntShortHashMap(this.size());
        map.putAll((IntShortMap)this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntShortMapSerializationProxy((IntShortMap)this);
    }

    protected static class ImmutableIntShortMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntShortMap map;

        public ImmutableIntShortMapSerializationProxy() {
        }

        protected ImmutableIntShortMapSerializationProxy(IntShortMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((IntShortProcedure)new CheckedIntShortProcedure(){

                    @Override
                    public void safeValue(int key, short value) throws IOException {
                        out.writeInt(key);
                        out.writeShort(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntShortHashMap deserializedMap = new IntShortHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readShort());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

