/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.strategy.immutable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.parallel.BatchIterable;
import org.eclipse.collections.impl.set.immutable.AbstractImmutableSet;
import org.eclipse.collections.impl.set.strategy.immutable.ImmutableSetWithHashingStrategySerializationProxy;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;

@Immutable
final class ImmutableUnifiedSetWithHashingStrategy<T>
extends AbstractImmutableSet<T>
implements Serializable,
BatchIterable<T> {
    private static final long serialVersionUID = 1L;
    private final UnifiedSetWithHashingStrategy<T> delegate;

    private ImmutableUnifiedSetWithHashingStrategy(UnifiedSetWithHashingStrategy<T> delegate) {
        this.delegate = delegate;
    }

    public static <T> ImmutableSet<T> newSetWith(HashingStrategy<? super T> hashingStrategy, T ... elements) {
        return new ImmutableUnifiedSetWithHashingStrategy<T>(UnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, elements));
    }

    public static <T> ImmutableSet<T> newSet(HashingStrategy<? super T> hashingStrategy, Iterable<T> iterable) {
        return new ImmutableUnifiedSetWithHashingStrategy<T>(UnifiedSetWithHashingStrategy.newSet(hashingStrategy, iterable));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIteratorAdapter<T>(this.delegate.iterator());
    }

    public T getFirst() {
        return this.delegate.getFirst();
    }

    public T getLast() {
        return this.delegate.getLast();
    }

    public T getOnly() {
        return (T)this.delegate.getOnly();
    }

    public void each(Procedure<? super T> procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int getBatchCount(int batchSize) {
        return this.delegate.getBatchCount(batchSize);
    }

    @Override
    public void batchForEach(Procedure<? super T> procedure, int sectionIndex, int sectionCount) {
        this.delegate.batchForEach(procedure, sectionIndex, sectionCount);
    }

    private Object writeReplace() {
        return new ImmutableSetWithHashingStrategySerializationProxy<T>(this, this.delegate.hashingStrategy());
    }

    @Override
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return this.delegate.asParallel(executorService, batchSize);
    }
}

