/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction0;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatDoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.FloatDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.map.primitive.FloatDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableFloatDoubleMap;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatDoublePair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.factory.primitive.FloatDoubleMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableFloatKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableFloatMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableFloatKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedFloatDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableFloatDoubleMap;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class FloatDoubleHashMap
extends AbstractMutableDoubleValuesMap
implements MutableFloatDoubleMap,
Externalizable,
MutableFloatKeysMap {
    private static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private float[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableDoubleValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public FloatDoubleHashMap() {
        this.allocateTable(16);
    }

    public FloatDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public FloatDoubleHashMap(FloatDoubleMap map) {
        if (map instanceof FloatDoubleHashMap && ((FloatDoubleHashMap)map).occupiedWithSentinels == 0) {
            FloatDoubleHashMap hashMap = (FloatDoubleHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1) {
        return new FloatDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1, float key2, double value2) {
        return new FloatDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1, float key2, double value2, float key3, double value3) {
        return new FloatDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1, float key2, double value2, float key3, double value3, float key4, double value4) {
        return new FloatDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected double getEmptyValue() {
        return 0.0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected double getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatDoubleMap)) {
            return false;
        }
        FloatDoubleMap other = (FloatDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0f) || other.containsKey(1.0f)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0f) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow(0.0f)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0f) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow(1.0f)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += Float.floatToIntBits(0.0f) ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += Float.floatToIntBits(1.0f) ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += Float.floatToIntBits(this.keys[i]) ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0.0f).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1.0f).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0.0f);
        Arrays.fill(this.values, 0.0);
    }

    public void put(float key, double value) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, key) == 0) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(FloatDoubleMap map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void removeKey(float key) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(float key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(float key, double value) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            double oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(float key, double value) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPut(float key, DoubleFunction0 function) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> double getIfAbsentPutWith(float key, DoubleFunction<? super P> function, P parameter) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double getIfAbsentPutWithKey(float key, FloatToDoubleFunction function) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        double value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public double addToValue(float key, double toBeAdded) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(float key, double value, int index) {
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1.0f;
        this.values[index] = 0.0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        float[] copy = new float[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public double updateValue(float key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public FloatDoubleHashMap withKeyValue(float key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public FloatDoubleHashMap withKeysValues(float key1, double value1, float key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public FloatDoubleHashMap withKeysValues(float key1, double value1, float key2, double value2, float key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public FloatDoubleHashMap withKeysValues(float key1, double value1, float key2, double value2, float key3, double value3, float key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public FloatDoubleHashMap withoutKey(float key) {
        this.removeKey(key);
        return this;
    }

    public FloatDoubleHashMap withoutAllKeys(FloatIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    public MutableFloatDoubleMap asUnmodifiable() {
        return new UnmodifiableFloatDoubleMap(this);
    }

    public MutableFloatDoubleMap asSynchronized() {
        return new SynchronizedFloatDoubleMap(this);
    }

    public ImmutableFloatDoubleMap toImmutable() {
        return FloatDoubleMaps.immutable.ofAll((FloatDoubleMap)this);
    }

    public double get(float key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(float key, double ifAbsent) {
        if (FloatDoubleHashMap.isEmptyKey(key) || FloatDoubleHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private double getForSentinel(float key, double ifAbsent) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private double slowGetIfAbsent(float key, double ifAbsent) {
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private double fastGetIfAbsent(float key, double ifAbsent) {
        int index = this.mask((int)key);
        for (int i = 0; i < 8; ++i) {
            float keyAtIndex = this.keys[index];
            if (Float.compare(keyAtIndex, key) == 0) {
                return this.values[index];
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private double slowGetIfAbsentTwo(float key, double ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public double getOrThrow(float key) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(float key) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(key)], key) == 0;
    }

    @Override
    public void forEachKey(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(FloatDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyFloatIterable keysView() {
        return new KeysView();
    }

    public RichIterable<FloatDoublePair> keyValuesView() {
        return new KeyValuesView();
    }

    public FloatDoubleHashMap select(FloatDoublePredicate predicate) {
        FloatDoubleHashMap result = new FloatDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public FloatDoubleHashMap reject(FloatDoublePredicate predicate) {
        FloatDoubleHashMap result = new FloatDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeFloat(0.0f);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeFloat(1.0f);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeFloat(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readFloat(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        float[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(float element) {
        int index = this.mask((int)element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(float element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            float keyAtIndex = this.keys[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(float element, int removedIndex) {
        int nextIndex = SpreadFunctions.floatSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.floatSpreadTwo(element)) | 1;
        float keyAtIndex;
        while (Float.compare(keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(float element) {
        int code = SpreadFunctions.floatSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(float element) {
        int code = SpreadFunctions.floatSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new float[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !FloatDoubleHashMap.isEmptyKey(key) && !FloatDoubleHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !FloatDoubleHashMap.isEmptyKey(this.keys[index]) && !FloatDoubleHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableFloatSet keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ float[] access$302(FloatDoubleHashMap x0, float[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(FloatDoubleHashMap x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<FloatDoublePair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super FloatDoublePair> procedure) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.zeroValue));
                }
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(FloatDoubleHashMap.this.keys[i], FloatDoubleHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super FloatDoublePair> objectIntProcedure) {
            int index = 0;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(FloatDoubleHashMap.this.keys[i], FloatDoubleHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super FloatDoublePair, ? super P> procedure, P parameter) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(FloatDoubleHashMap.this.keys[i], FloatDoubleHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<FloatDoublePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<FloatDoublePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public FloatDoublePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (FloatDoubleHashMap.this.containsKey(0.0f)) {
                        return PrimitiveTuples.pair(0.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (FloatDoubleHashMap.this.containsKey(1.0f)) {
                        return PrimitiveTuples.pair(1.0f, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.oneValue);
                    }
                }
                float[] keys = FloatDoubleHashMap.this.keys;
                while (!FloatDoubleHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                FloatDoublePair result = PrimitiveTuples.pair(keys[this.position], FloatDoubleHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != FloatDoubleHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableDoubleValuesMap.AbstractDoubleValuesCollection {
        private ValuesCollection() {
        }

        public MutableDoubleIterator doubleIterator() {
            return FloatDoubleHashMap.this.doubleIterator();
        }

        public boolean remove(double item) {
            int oldSize = FloatDoubleHashMap.this.size();
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsZeroKey && Double.compare(item, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.zeroValue) == 0) {
                    FloatDoubleHashMap.this.removeKey(0.0f);
                }
                if (((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsOneKey && Double.compare(item, ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.oneValue) == 0) {
                    FloatDoubleHashMap.this.removeKey(1.0f);
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i]) || Double.compare(item, FloatDoubleHashMap.this.values[i]) != 0) continue;
                FloatDoubleHashMap.this.removeKey(FloatDoubleHashMap.this.keys[i]);
            }
            return oldSize != FloatDoubleHashMap.this.size();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = FloatDoubleHashMap.this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            FloatDoubleHashMap retained = FloatDoubleHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$9859dacf$1((DoubleSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                FloatDoubleHashMap.access$302(FloatDoubleHashMap.this, retained.keys);
                FloatDoubleHashMap.access$502(FloatDoubleHashMap.this, retained.values);
                FloatDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                FloatDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                FloatDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        private static /* synthetic */ boolean lambda$retainAll$9859dacf$1(DoubleSet sourceSet, float key, double value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySet
    extends AbstractMutableFloatKeySet {
        private KeySet() {
        }

        @Override
        protected MutableFloatKeysMap getOuter() {
            return FloatDoubleHashMap.this;
        }

        @Override
        protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
            return FloatDoubleHashMap.this.sentinelValues;
        }

        @Override
        protected float getKeyAtIndex(int index) {
            return FloatDoubleHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return FloatDoubleHashMap.this.keys.length;
        }

        public MutableFloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(FloatIterable source) {
            int oldSize = FloatDoubleHashMap.this.size();
            Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
            FloatDoubleHashMap retained = FloatDoubleHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$93ed891d$1((FloatSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                FloatDoubleHashMap.access$302(FloatDoubleHashMap.this, retained.keys);
                FloatDoubleHashMap.access$502(FloatDoubleHashMap.this, retained.values);
                FloatDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                FloatDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                FloatDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(float ... source) {
            return this.retainAll(FloatHashSet.newSetWith(source));
        }

        public FloatSet freeze() {
            FloatDoubleHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                containsZeroKey = ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((FloatDoubleHashMap)FloatDoubleHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableFloatMapKeySet(FloatDoubleHashMap.this.keys, FloatDoubleHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        private static /* synthetic */ boolean lambda$retainAll$93ed891d$1(FloatSet sourceSet, float key, double value) {
            return sourceSet.contains(key);
        }
    }

    private class KeySetIterator
    implements MutableFloatIterator {
        private int count;
        private int position;
        private float lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatDoubleHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatDoubleHashMap.this.containsKey(0.0f)) {
                    this.lastKey = 0.0f;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatDoubleHashMap.this.containsKey(1.0f)) {
                    this.lastKey = 1.0f;
                    return this.lastKey;
                }
            }
            float[] keys = FloatDoubleHashMap.this.keys;
            while (!FloatDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            FloatDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyFloatIterable {
        private KeysView() {
        }

        public FloatIterator floatIterator() {
            return new UnmodifiableFloatIterator((FloatIterator)new KeySetIterator());
        }

        public void each(FloatProcedure procedure) {
            FloatDoubleHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private float lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatDoubleHashMap.this.containsKey(0.0f)) {
                    this.lastKey = 0.0f;
                    return FloatDoubleHashMap.this.get(0.0f);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatDoubleHashMap.this.containsKey(1.0f)) {
                    this.lastKey = 1.0f;
                    return FloatDoubleHashMap.this.get(1.0f);
                }
            }
            float[] keys = FloatDoubleHashMap.this.keys;
            while (!FloatDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            double result = FloatDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            FloatDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

