/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayAssert
extends ObjectGroupAssert<ObjectArrayAssert, Object[]> {
    protected ObjectArrayAssert(Object ... actual) {
        super(ObjectArrayAssert.class, actual);
    }

    public ObjectArrayAssert hasAllElementsOfType(Class<?> type) {
        this.validateIsNotNull(type);
        this.isNotNull();
        for (Object o : (Object[])this.actual) {
            if (type.isInstance(o)) continue;
            this.failIfCustomMessageIsSet();
            this.fail(Formatting.format("not all elements in array:<%s> belong to the type:<%s>", this.actual, type));
        }
        return this;
    }

    public ObjectArrayAssert hasAtLeastOneElementOfType(Class<?> type) {
        this.validateIsNotNull(type);
        this.isNotNull();
        boolean found = false;
        for (Object o : (Object[])this.actual) {
            if (!type.isInstance(o)) continue;
            found = true;
            break;
        }
        if (found) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("array:<%s> does not have any elements of type:<%s>", this.actual, type));
    }

    private void validateIsNotNull(Class<?> type) {
        if (type == null) {
            throw new NullPointerException(ErrorMessages.unexpectedNullType(this.rawDescription()));
        }
    }

    @Override
    public ObjectArrayAssert isEqualTo(Object[] expected) {
        if (Arrays.deepEquals((Object[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public ObjectArrayAssert isNotEqualTo(Object[] array) {
        if (!Arrays.deepEquals((Object[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    @Override
    public ObjectArrayAssert onProperty(String propertyName) {
        this.isNotNull();
        if (((Object[])this.actual).length == 0) {
            return new ObjectArrayAssert(new Object[0]);
        }
        List<Object> values = PropertySupport.instance().propertyValues(propertyName, Collections.list((Object[])((Object[])this.actual)));
        return new ObjectArrayAssert(values.toArray());
    }

    @Override
    protected Set<Object> actualAsSet() {
        return Collections.set((Object[])((Object[])this.actual));
    }

    @Override
    protected List<Object> actualAsList() {
        return Collections.list((Object[])((Object[])this.actual));
    }

    @Override
    protected int actualGroupSize() {
        return ((Object[])this.actual).length;
    }
}

