/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.parsing.marker;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Lists;
import dyvil.io.Console;
import dyvil.lang.Strings;
import dyvil.source.Source;
import dyvil.source.position.SourcePosition;
import dyvil.tuple.Tuple;
import dyvil.util.MarkerLevel;
import dyvil.util.MatchError;
import dyvilx.tools.parsing.marker.BaseMarkers;
import dyvilx.tools.parsing.marker.Marker;
import dyvilx.tools.parsing.marker.MarkerList;
import dyvilx.tools.parsing.marker.MarkerStyle;
import java.io.Serializable;
import java.io.Writer;
import java.util.BitSet;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"source", "style", "colors"})
public class MarkerPrinter
implements Serializable {
    protected final @NonNull Source source;
    protected final @NonNull MarkerStyle style;
    protected final boolean colors;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MarkerPrinter markerPrinter = (MarkerPrinter)object;
        return this.source.equals(markerPrinter.source) && ((Object)((Object)this.style)).equals((Object)markerPrinter.style) && this.colors == markerPrinter.colors;
    }

    public int hashCode() {
        Source source = this.source;
        MarkerStyle markerStyle = this.style;
        return (((31 + (source != null ? source.hashCode() : 0)) * 31 + (markerStyle != null ? ((Object)((Object)markerStyle)).hashCode() : 0)) * 31 + (this.colors ? 1231 : 1237)) * 31;
    }

    public String toString() {
        return "MarkerPrinter(" + this.source + ", " + (Object)((Object)this.style) + ", " + this.colors + ")";
    }

    @DyvilName(value="source")
    public @NonNull Source getSource() {
        return this.source;
    }

    @DyvilName(value="style")
    public @NonNull MarkerStyle getStyle() {
        return this.style;
    }

    public boolean colors() {
        return this.colors;
    }

    public MarkerPrinter(@NonNull Source source, @NonNull MarkerStyle style, boolean colors) {
        this.source = source;
        this.style = style;
        this.colors = colors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void print(@NonNull MarkerList markers, @NonNull Writer writer) {
        MarkerStyle markerStyle = this.style;
        switch (markerStyle.name().hashCode()) {
            case 70375: {
                if (markerStyle != MarkerStyle.GCC) throw new MatchError((Object)markerStyle);
                this.printGCC(markers, writer);
                return;
            }
            case 65535812: {
                if (markerStyle != MarkerStyle.DYVIL) throw new MatchError((Object)markerStyle);
                this.printHuman(markers, writer);
                return;
            }
            case 1543295015: {
                if (markerStyle != MarkerStyle.MACHINE) throw new MatchError((Object)markerStyle);
                this.printMachine(markers, writer);
                return;
            }
            default: {
                throw new MatchError((Object)markerStyle);
            }
        }
    }

    @DyvilModifiers(value=0x8000000L)
    void printHuman(@NonNull MarkerList markers, @NonNull Writer writer) {
        Lists.sort(markers);
        BitSet lines = new BitSet(this.source.lineCount());
        int lastLine = 0;
        for (int i = markers.size() - 1; i >= 0; --i) {
            Marker marker = Lists.subscript(markers, i);
            SourcePosition position = marker.getPosition();
            int endLine = position.endLine();
            lines.set(position.startLine(), endLine + 1);
            if (endLine <= lastLine) continue;
            lastLine = endLine;
        }
        int n = (int)Math.log10(lastLine) + 1;
        String string = new StringBuilder(28).append("%").append(n).append("d | %s\n").toString();
        String string2 = Strings.$times(".", n).concat(" | ");
        int markerIndex = 0;
        int line = lines.nextSetBit(0);
        while (line >= 0) {
            writer.write(String.format(string, line, this.source.line(line)));
            while (markerIndex < markers.size() && line == Lists.subscript(markers, markerIndex).getPosition().endLine()) {
                this.printHuman(Lists.subscript(markers, markerIndex), string2, writer);
                ++markerIndex;
            }
            line = lines.nextSetBit(line + 1);
        }
    }

    @DyvilModifiers(value=0x8000000L)
    void printHuman(@NonNull Marker marker, @NonNull String indent, @NonNull Writer writer) {
        writer.write(indent);
        this.printIndicator(marker, writer);
        writer.write("\n");
        writer.write(indent);
        if (this.colors) {
            writer.write(marker.getLevel().getColor());
        }
        writer.write(MarkerPrinter.levelName(marker.getLevel()));
        writer.write(": ");
        writer.write(marker.getMessage());
        if (this.colors) {
            writer.write(Console.ANSI_RESET);
        }
        writer.write("\n");
        for (String infoLine : marker.getInfo()) {
            writer.write(indent);
            writer.write("\t");
            writer.write(infoLine);
            writer.write("\n");
        }
        writer.write(indent);
        writer.write("\n");
    }

    private void printIndicator(@NonNull Marker marker, @NonNull Writer writer) {
        SourcePosition position = marker.getPosition();
        int startColumn = position.startColumn();
        int endColumn = position.endColumn();
        String line = this.source.line(position.endLine());
        int limit = Math.min(startColumn, line.length());
        int n = limit;
        for (int i = 0; i < n; ++i) {
            writer.write(Strings.subscript(line, i) == '\t' ? "\t" : " ");
        }
        if (this.colors) {
            writer.write(marker.getLevel().getColor());
        }
        int n2 = endColumn;
        for (int i = startColumn; i < n2; ++i) {
            writer.write("^");
        }
        if (startColumn == endColumn) {
            writer.write("^");
        }
        if (this.colors) {
            writer.write(Console.ANSI_RESET);
        }
    }

    private void printMachine(@NonNull MarkerList markers, @NonNull Writer writer) {
        Lists.sort(markers);
        for (Marker marker : markers) {
            this.printMachine(marker, writer);
        }
    }

    private void printMachine(@NonNull Marker marker, @NonNull Writer writer) {
        String location = new StringBuilder(43).append("").append(MarkerPrinter.sourcePath(this.source)).append(":").append(marker.getPosition().toPositionString()).append(": ").toString();
        writer.write(location);
        if (this.colors) {
            writer.write(marker.getLevel().getColor());
        }
        writer.write(MarkerPrinter.levelName(marker.getLevel()));
        writer.write(": ");
        writer.write(marker.getMessage());
        if (this.colors) {
            writer.write(Console.ANSI_RESET);
        }
        writer.write("\n");
        for (String info : marker.getInfo()) {
            writer.write(location);
            writer.write(MarkerPrinter.levelName("note"));
            writer.write(": ");
            writer.write(info);
            writer.write("\n");
        }
    }

    private void printGCC(@NonNull MarkerList markers, @NonNull Writer writer) {
        Lists.sort(markers);
        for (Marker marker : markers) {
            this.printGCC(marker, writer);
        }
    }

    private void printGCC(@NonNull Marker marker, @NonNull Writer writer) {
        this.printMachine(marker, writer);
        writer.write(this.source.line(marker.getPosition().endLine()));
        writer.write("\n");
        this.printIndicator(marker, writer);
        writer.write("\n");
    }

    private static @NonNull String sourcePath(@NonNull Source source) {
        String string;
        String string2 = source.getFilePath();
        if (string2 != null) {
            string = string2;
        } else {
            String string3 = BaseMarkers.INSTANCE.getString("marker.input_source");
            string = string3;
            string3.getClass();
        }
        return string;
    }

    private static @NonNull String levelName(@NonNull MarkerLevel level) {
        String string = level.name().toLowerCase();
        string.getClass();
        return MarkerPrinter.levelName(string);
    }

    private static @NonNull String levelName(@NonNull String levelID) {
        String string = BaseMarkers.INSTANCE.getString(new StringBuilder(33).append("marker_level.").append(levelID).append("").toString());
        string.getClass();
        return string;
    }

    public static final @NonNull MarkerPrinter apply(@NonNull Source source, @NonNull MarkerStyle style, boolean colors) {
        return new MarkerPrinter(source, style, colors);
    }

    public static final @NonNull Tuple.Of3<@NonNull Source, @NonNull MarkerStyle, @Primitive Boolean> unapply(@NonNull MarkerPrinter value) {
        return new Tuple.Of3<Source, MarkerStyle, Boolean>(value.source, value.style, value.colors);
    }

    public static final @Nullable Tuple.Of3<@NonNull Source, @NonNull MarkerStyle, @Primitive Boolean> unapply(@Primitive Object value) {
        return value instanceof MarkerPrinter ? MarkerPrinter.unapply((MarkerPrinter)value) : null;
    }
}

