/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.parsing.marker;

import dyvil.annotation.Deprecated;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.io.AppendablePrintStream;
import dyvil.source.position.SourcePosition;
import dyvil.tuple.Tuple;
import dyvil.util.MarkerLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"position", "level", "message"})
public class Marker
implements Comparable<Marker>,
Serializable {
    protected final @NonNull SourcePosition position;
    protected final @NonNull MarkerLevel level;
    protected final @NonNull String message;
    protected final @NonNull List<@NonNull String> info;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Marker marker = (Marker)object;
        return this.position.equals(marker.position) && ((Object)((Object)this.level)).equals((Object)marker.level) && this.message.equals(marker.message);
    }

    public int hashCode() {
        SourcePosition sourcePosition = this.position;
        MarkerLevel markerLevel = this.level;
        String string = this.message;
        return (((31 + (sourcePosition != null ? sourcePosition.hashCode() : 0)) * 31 + (markerLevel != null ? ((Object)((Object)markerLevel)).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "Marker(" + this.position + ", " + (Object)((Object)this.level) + ", " + this.message + ")";
    }

    @DyvilName(value="position")
    public @NonNull SourcePosition getPosition() {
        return this.position;
    }

    @DyvilName(value="level")
    public @NonNull MarkerLevel getLevel() {
        return this.level;
    }

    @DyvilName(value="message")
    public @NonNull String getMessage() {
        return this.message;
    }

    @DyvilName(value="info")
    public @NonNull List<@NonNull String> getInfo() {
        return this.info;
    }

    public Marker(SourcePosition position, @NonNull String message) {
        SourcePosition sourcePosition = position;
        this(sourcePosition != null ? sourcePosition : SourcePosition.ORIGIN, MarkerLevel.ERROR, message);
    }

    public Marker(@NonNull SourcePosition position, @NonNull MarkerLevel level, @NonNull String message) {
        this.info = new ArrayList<String>();
        this.position = position;
        this.level = level;
        this.message = message;
    }

    @Deprecated
    public boolean isIgnored() {
        return ((Object)((Object)this.level)).equals((Object)MarkerLevel.IGNORE);
    }

    public boolean isError() {
        return this.level.isError();
    }

    public boolean isWarning() {
        return this.level.isWarning();
    }

    @DyvilName(value="color")
    public String getColor() {
        return this.level.getColor();
    }

    @DyvilName(value="add")
    public void addInfo(@NonNull String info) {
        this.info.add(info);
    }

    @DyvilName(value="add")
    public void addError(@NonNull Throwable error) {
        StringBuilder builder = new StringBuilder();
        error.printStackTrace(new AppendablePrintStream(builder));
        this.info.addAll(Arrays.asList(builder.toString().split("\n")));
    }

    @Override
    public int compareTo(@NonNull Marker that) {
        int byPos = this.position.compareTo(that.position);
        if (byPos != 0) {
            return byPos;
        }
        int byLevel = -this.level.compareTo(that.level);
        if (byLevel != 0) {
            return byLevel;
        }
        return this.message.compareTo(that.message);
    }

    public boolean equals(@NonNull Marker that) {
        return this.equals((Object)that);
    }

    public static final @NonNull Marker apply(@NonNull SourcePosition position, @NonNull MarkerLevel level, @NonNull String message) {
        return new Marker(position, level, message);
    }

    public static final @NonNull Tuple.Of3<@NonNull SourcePosition, @NonNull MarkerLevel, @NonNull String> unapply(@NonNull Marker value) {
        return new Tuple.Of3<SourcePosition, MarkerLevel, String>(value.position, value.level, value.message);
    }

    public static final @Nullable Tuple.Of3<@NonNull SourcePosition, @NonNull MarkerLevel, @NonNull String> unapply(@Primitive Object value) {
        return value instanceof Marker ? Marker.unapply((Marker)value) : null;
    }
}

