/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.parsing.lexer;

import dyvil.lang.Name;
import dyvilx.tools.parsing.TokenList;
import dyvilx.tools.parsing.lexer.BaseSymbols;
import dyvilx.tools.parsing.lexer.CharacterTypes;
import dyvilx.tools.parsing.lexer.Lexer;
import dyvilx.tools.parsing.lexer.Symbols;
import dyvilx.tools.parsing.marker.MarkerList;
import dyvilx.tools.parsing.token.DoubleToken;
import dyvilx.tools.parsing.token.FloatToken;
import dyvilx.tools.parsing.token.IdentifierToken;
import dyvilx.tools.parsing.token.IntToken;
import dyvilx.tools.parsing.token.LongToken;
import dyvilx.tools.parsing.token.StringToken;
import dyvilx.tools.parsing.token.SymbolToken;

public final class DyvilLexer
extends Lexer {
    private int parens;
    private boolean interpolationEnd;

    public DyvilLexer(MarkerList markers, Symbols symbols) {
        super(markers, symbols);
    }

    public void setInterpolationEnd() {
        this.interpolationEnd = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public TokenList tokenize(String code, int cursor, int line, int column) {
        this.init(code, cursor, line, column);
        block5: while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 0: {
                    break block5;
                }
                case 40: {
                    ++this.parens;
                    break;
                }
                case 41: {
                    if (--this.parens < 0 && this.interpolationEnd) break block5;
                }
            }
            this.parseCharacter(currentChar);
        }
        this.finish();
        return this.tokens;
    }

    @Override
    protected void parseCharacter(int currentChar) {
        switch (currentChar) {
            case 96: {
                this.parseBacktickIdentifier();
                return;
            }
            case 34: {
                this.parseDoubleString();
                return;
            }
            case 39: {
                this.parseSingleString();
                return;
            }
            case 64: {
                switch (this.nextCodePoint()) {
                    case 34: {
                        this.parseVerbatimString();
                        return;
                    }
                    case 39: {
                        this.parseVerbatimChar();
                        return;
                    }
                }
                this.parseIdentifier(64, 131072);
                return;
            }
            case 47: {
                switch (this.nextCodePoint()) {
                    case 42: {
                        this.parseBlockComment();
                        return;
                    }
                    case 47: {
                        this.parseLineComment();
                        return;
                    }
                }
                this.parseIdentifier(47, 131072);
                return;
            }
            case 40: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 65544, this.line, this.column));
                this.advance();
                return;
            }
            case 41: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 0x110008, this.line, this.column));
                this.advance();
                return;
            }
            case 91: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 131080, this.line, this.column));
                this.advance();
                return;
            }
            case 93: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 1179656, this.line, this.column));
                this.advance();
                return;
            }
            case 123: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 262152, this.line, this.column));
                this.advance();
                return;
            }
            case 125: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 1310728, this.line, this.column));
                this.advance();
                return;
            }
            case 46: {
                int n = this.nextCodePoint();
                if (CharacterTypes.isIdentifierSymbol(n) || n == 46) {
                    this.parseIdentifier(46, 262144);
                    return;
                }
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 65540, this.line, this.column));
                this.advance();
                return;
            }
            case 59: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 196612, this.line, this.column));
                this.advance();
                return;
            }
            case 44: {
                this.tokens.append(new SymbolToken(BaseSymbols.INSTANCE, 262148, this.line, this.column));
                this.advance();
                return;
            }
            case 36: 
            case 95: {
                this.parseIdentifier(currentChar, 196608);
                return;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.parseNumberLiteral(currentChar);
                return;
            }
            case 10: {
                this.newLine();
                return;
            }
            case 9: 
            case 32: {
                this.advance();
                return;
            }
        }
        if (CharacterTypes.isIdentifierSymbol(currentChar)) {
            this.parseIdentifier(currentChar, 131072);
            return;
        }
        if (CharacterTypes.isIdentifierPart(currentChar)) {
            this.parseIdentifier(currentChar, 65536);
            return;
        }
        this.advance(currentChar);
    }

    private void parseBacktickIdentifier() {
        int startColumn = this.column;
        this.advance();
        this.clearBuffer();
        block6: while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 10: {
                    this.newLine();
                    continue block6;
                }
                case 8: 
                case 9: {
                    this.advance();
                    continue block6;
                }
                case 0: {
                    this.error("identifier.backtick.unclosed");
                }
                case 96: {
                    if (this.buffer.length() == 0) {
                        this.error("identifier.backtick.empty");
                        this.buffer.append('_');
                    }
                    this.advance();
                    this.tokens.append(new IdentifierToken(Name.from(this.buffer.toString()), 4097, this.line, startColumn, this.column));
                    return;
                }
            }
            this.buffer.appendCodePoint(currentChar);
            this.advance(currentChar);
        }
    }

    private void parseSingleString() {
        int startColumn = this.column;
        this.advance();
        this.clearBuffer();
        block7: while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 92: {
                    this.parseEscape(this.nextCodePoint());
                    continue block7;
                }
                case 8: 
                case 9: {
                    this.advance();
                    continue block7;
                }
                case 10: {
                    this.newLine();
                    this.error("string.single.newline");
                    continue block7;
                }
                case 0: {
                    this.error("string.single.unclosed");
                }
                case 39: {
                    this.advance();
                    this.tokens.append(new StringToken(this.buffer.toString(), 1024, this.line, this.line, startColumn, this.column));
                    return;
                }
            }
            this.buffer.appendCodePoint(currentChar);
            this.advance(currentChar);
        }
    }

    private void parseDoubleString() {
        int startColumn = this.column;
        int startLine = this.line;
        boolean stringPart = false;
        this.advance();
        this.clearBuffer();
        block7: while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 92: {
                    int nextChar = this.nextCodePoint();
                    if (nextChar == 40) {
                        this.advance2();
                        this.tokens.append(new StringToken(this.buffer.toString(), stringPart ? 131328 : 65792, startLine, this.line, startColumn, this.column));
                        this.parseInterpolationValue();
                        startColumn = this.column;
                        startLine = this.line;
                        stringPart = true;
                        this.advance();
                        this.clearBuffer();
                        continue block7;
                    }
                    this.parseEscape(nextChar);
                    continue block7;
                }
                case 0: {
                    this.error("string.double.unclosed");
                }
                case 34: {
                    this.advance();
                    this.tokens.append(new StringToken(this.buffer.toString(), stringPart ? 262400 : 256, startLine, this.line, startColumn, this.column));
                    return;
                }
                case 10: {
                    this.newLine();
                    break;
                }
                case 9: {
                    this.advance();
                    continue block7;
                }
            }
            this.buffer.appendCodePoint(currentChar);
            this.advance(currentChar);
        }
    }

    private void parseInterpolationValue() {
        DyvilLexer lexer = new DyvilLexer(this.markers, this.symbols);
        lexer.setInterpolationEnd();
        this.useSubLexer(lexer);
    }

    private void parseVerbatimString() {
        int startColumn = this.column;
        int startLine = this.line;
        this.advance2();
        this.clearBuffer();
        block6: while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 0: {
                    this.error("string.verbatim.unclosed");
                }
                case 34: {
                    this.advance();
                    this.tokens.append(new StringToken(this.buffer.toString(), 2048, startLine, this.line, startColumn, this.column));
                    return;
                }
                case 10: {
                    this.newLine();
                    continue block6;
                }
                case 9: {
                    this.advance();
                    continue block6;
                }
            }
            this.buffer.appendCodePoint(currentChar);
            this.advance(currentChar);
        }
    }

    private void parseVerbatimChar() {
        int startColumn = this.column;
        int startLine = this.line;
        this.advance2();
        this.clearBuffer();
        int currentChar = this.codePoint();
        switch (currentChar) {
            case 92: {
                this.parseEscape(this.nextCodePoint());
                break;
            }
            case 10: {
                this.buffer.append('\n');
                this.newLine();
                break;
            }
            default: {
                this.buffer.appendCodePoint(currentChar);
                this.advance(currentChar);
            }
        }
        while ((currentChar = this.codePoint()) != 39) {
            if (currentChar == 0) {
                this.error("char.verbatim.unclosed");
                break;
            }
            this.error("char.verbatim.invalid");
            this.advance(currentChar);
        }
        this.advance();
        this.tokens.append(new StringToken(this.buffer.toString(), 4096, startLine, this.line, startColumn, this.column));
    }

    private void parseNumberLiteral(int currentChar) {
        int radix;
        int startColumn = this.column;
        this.advance();
        this.clearBuffer();
        if (currentChar == 48) {
            switch (this.codePoint()) {
                case 79: 
                case 111: {
                    this.advance();
                    radix = 8;
                    break;
                }
                case 88: 
                case 120: {
                    this.advance();
                    radix = 16;
                    break;
                }
                case 66: 
                case 98: {
                    this.advance();
                    radix = 2;
                    break;
                }
                default: {
                    this.buffer.append('0');
                    radix = 10;
                    break;
                }
            }
        } else {
            this.buffer.append((char)currentChar);
            radix = 10;
        }
        int type = 0;
        block33: while (true) {
            currentChar = this.codePoint();
            switch (currentChar) {
                case 0: {
                    break block33;
                }
                case 48: 
                case 49: {
                    this.buffer.append((char)currentChar);
                    this.advance();
                    continue block33;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    if (radix < 8) break block33;
                    this.buffer.append((char)currentChar);
                    this.advance();
                    continue block33;
                }
                case 56: 
                case 57: {
                    if (radix < 10) break block33;
                    this.buffer.append((char)currentChar);
                    this.advance();
                    continue block33;
                }
                case 65: 
                case 66: 
                case 67: 
                case 97: 
                case 98: 
                case 99: {
                    if (radix != 16) break block33;
                    this.buffer.append((char)currentChar);
                    this.advance();
                    continue block33;
                }
                case 95: {
                    this.advance();
                    continue block33;
                }
                case 68: 
                case 100: {
                    if (radix == 16) {
                        this.buffer.append((char)currentChar);
                        this.advance();
                        continue block33;
                    }
                    if (radix < 10 || CharacterTypes.isIdentifierPart(this.nextCodePoint())) break block33;
                    this.advance();
                    type = 3;
                    continue block33;
                }
                case 46: {
                    if (radix != 10 || !CharacterTypes.isDigit(this.nextCodePoint())) break block33;
                    this.buffer.append('.');
                    this.advance();
                    type = 3;
                    continue block33;
                }
                case 69: 
                case 101: {
                    if (radix == 16) {
                        this.buffer.append((char)currentChar);
                        this.advance();
                        continue block33;
                    }
                    if (radix != 10) break block33;
                    int n = this.nextCodePoint();
                    if (CharacterTypes.isDigit(n)) {
                        this.buffer.append((char)currentChar);
                        this.advance();
                        type = 3;
                        continue block33;
                    }
                    if (n != 45) break block33;
                    this.buffer.append('e').append('-');
                    this.advance();
                    type = 3;
                    continue block33;
                }
                case 70: 
                case 102: {
                    if (radix == 16) {
                        this.buffer.append((char)currentChar);
                        this.advance();
                        continue block33;
                    }
                    if (radix < 10 || CharacterTypes.isIdentifierPart(this.nextCodePoint())) break block33;
                    this.advance();
                    type = 2;
                    continue block33;
                }
                case 76: 
                case 108: {
                    if (CharacterTypes.isIdentifierPart(this.nextCodePoint())) break block33;
                    this.advance();
                    type = 1;
                    continue block33;
                }
                case 80: 
                case 112: {
                    if (radix != 16) break block33;
                    this.buffer.append((char)currentChar);
                    this.advance();
                    type = 3;
                    continue block33;
                }
            }
            break;
        }
        switch (type) {
            case 0: {
                IntToken token = new IntToken(0, this.line, startColumn, this.column);
                try {
                    token.setValue(Integer.parseInt(this.buffer.toString(), radix));
                }
                catch (NumberFormatException ignored) {
                    this.error(token, "literal.integer.invalid");
                }
                this.tokens.append(token);
                return;
            }
            case 1: {
                LongToken token = new LongToken(0L, this.line, startColumn, this.column);
                try {
                    token.setValue(Long.parseLong(this.buffer.toString(), radix));
                }
                catch (NumberFormatException ignored) {
                    this.error(token, "literal.long.invalid");
                }
                this.tokens.append(token);
                return;
            }
            case 2: {
                FloatToken token = new FloatToken(0.0f, this.line, startColumn, this.column);
                try {
                    token.setValue(Float.parseFloat(this.buffer.toString()));
                }
                catch (NumberFormatException ignored) {
                    this.error(token, "literal.float.invalid");
                }
                this.tokens.append(token);
                return;
            }
            case 3: {
                DoubleToken token = new DoubleToken(0.0, this.line, startColumn, this.column);
                try {
                    if (radix == 16) {
                        this.buffer.insert(0, "0x");
                    }
                    token.setValue(Double.parseDouble(this.buffer.toString()));
                }
                catch (NumberFormatException ignored) {
                    this.error(token, "literal.double.invalid");
                }
                this.tokens.append(token);
                return;
            }
        }
    }

    private void parseLineComment() {
        this.advance2();
        while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 0: {
                    return;
                }
                case 10: {
                    this.newLine();
                    return;
                }
            }
            this.advance(currentChar);
        }
    }

    private void parseBlockComment() {
        int level = 1;
        this.advance2();
        block6: while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 0: {
                    this.error("comment.block.unclosed");
                    return;
                }
                case 10: {
                    this.newLine();
                    continue block6;
                }
                case 47: {
                    if (this.nextCodePoint() == 42) {
                        ++level;
                        this.advance2();
                        continue block6;
                    }
                    this.advance();
                    continue block6;
                }
                case 42: {
                    if (this.nextCodePoint() == 47) {
                        this.advance2();
                        if (--level != 0) continue block6;
                        return;
                    }
                    this.advance();
                    continue block6;
                }
            }
            this.advance(currentChar);
        }
    }

    private void parseIdentifier(int currentChar, int subtype) {
        int startColumn = this.column;
        this.clearBuffer();
        this.buffer.appendCodePoint(currentChar);
        this.advance(currentChar);
        block6: while (true) {
            currentChar = this.codePoint();
            switch (subtype) {
                case 65536: {
                    if (currentChar == 95 || currentChar == 36) {
                        this.buffer.append((char)currentChar);
                        this.advance();
                        subtype = 196608;
                        continue block6;
                    }
                    if (CharacterTypes.isIdentifierPart(currentChar)) {
                        this.buffer.appendCodePoint(currentChar);
                        this.advance(currentChar);
                        continue block6;
                    }
                    String id = this.buffer.toString();
                    int keyword = this.symbols.getKeywordType(id);
                    if (keyword != 0) {
                        this.tokens.append(new SymbolToken(this.symbols, keyword, this.line, startColumn));
                        return;
                    }
                    this.tokens.append(new IdentifierToken(Name.from(id), 65537, this.line, startColumn, this.column));
                    return;
                }
                case 262144: {
                    if (currentChar == 46) {
                        this.buffer.append('.');
                        this.advance();
                        continue block6;
                    }
                }
                case 131072: {
                    if (currentChar == 95 || currentChar == 36) {
                        this.buffer.append((char)currentChar);
                        this.advance();
                        subtype = 196608;
                        continue block6;
                    }
                    if (!CharacterTypes.isIdentifierSymbol(currentChar)) break block6;
                    this.buffer.appendCodePoint(currentChar);
                    this.advance();
                    subtype = 131072;
                    continue block6;
                }
                case 196608: {
                    if (currentChar == 95 || currentChar == 36) {
                        this.buffer.append((char)currentChar);
                        this.advance();
                        continue block6;
                    }
                    if (CharacterTypes.isIdentifierPart(currentChar)) {
                        this.buffer.appendCodePoint(currentChar);
                        this.advance(currentChar);
                        subtype = 65536;
                        continue block6;
                    }
                    if (!CharacterTypes.isIdentifierSymbol(currentChar)) break block6;
                    this.buffer.appendCodePoint(currentChar);
                    this.advance(currentChar);
                    subtype = 131072;
                    continue block6;
                }
            }
            break;
        }
        String id = this.buffer.toString();
        int symbol = this.symbols.getSymbolType(id);
        if (symbol != 0) {
            this.tokens.append(new SymbolToken(this.symbols, symbol, this.line, startColumn));
            return;
        }
        this.tokens.append(new IdentifierToken(Name.from(id), 131073, this.line, startColumn, this.column));
    }

    private void parseEscape(int nextChar) {
        switch (nextChar) {
            case 34: 
            case 39: 
            case 92: {
                this.buffer.append((char)nextChar);
                this.advance2();
                return;
            }
            case 110: {
                this.buffer.append('\n');
                this.advance2();
                return;
            }
            case 116: {
                this.buffer.append('\t');
                this.advance2();
                return;
            }
            case 114: {
                this.buffer.append('\r');
                this.advance2();
                return;
            }
            case 98: {
                this.buffer.append('\b');
                this.advance2();
                return;
            }
            case 102: {
                this.buffer.append('\f');
                this.advance2();
                return;
            }
            case 118: {
                this.buffer.append('\u000b');
                this.advance2();
                return;
            }
            case 97: {
                this.buffer.append('\u0007');
                this.advance2();
                return;
            }
            case 101: {
                this.buffer.append('\u001b');
                this.advance2();
                return;
            }
            case 48: {
                this.buffer.append('\u0000');
                this.advance2();
                return;
            }
            case 117: {
                int buf = 0;
                this.advance2();
                if (this.codePoint() != 123) {
                    this.error("escape.unicode.open_brace");
                    return;
                }
                this.advance();
                block18: while (true) {
                    int codePoint = this.codePoint();
                    switch (codePoint) {
                        case 10: {
                            this.error("escape.unicode.newline");
                            this.newLine();
                            continue block18;
                        }
                        case 9: 
                        case 32: 
                        case 95: {
                            this.advance();
                            continue block18;
                        }
                        case 125: {
                            this.advance();
                            break block18;
                        }
                        default: {
                            if (!CharacterTypes.isHexDigit(codePoint)) {
                                this.error("escape.unicode.close_brace");
                                break block18;
                            }
                            buf <<= 4;
                            buf += Character.digit(codePoint, 16);
                            this.advance();
                            continue block18;
                        }
                    }
                    break;
                }
                this.buffer.appendCodePoint(buf);
                return;
            }
        }
        this.advance();
        this.error("escape.invalid");
        this.advance();
    }
}

