/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.parsing;

import dyvilx.tools.parsing.IParserManager;
import dyvilx.tools.parsing.Parser;
import dyvilx.tools.parsing.ParserManager;
import dyvilx.tools.parsing.TokenIterator;
import dyvilx.tools.parsing.lexer.Symbols;
import dyvilx.tools.parsing.marker.Marker;
import dyvilx.tools.parsing.marker.MarkerList;
import dyvilx.tools.parsing.token.IToken;
import java.util.ArrayList;
import java.util.List;

public class TryParserManager
extends ParserManager {
    private boolean hasSyntaxErrors;
    private boolean reportErrors;
    private List<IToken> splitTokens;
    public static final int REPORT_ERRORS = 1;
    public static final int EXIT_ON_ROOT = 2;

    public TryParserManager(Symbols symbols) {
        super(symbols);
    }

    public TryParserManager(Symbols symbols, TokenIterator tokens) {
        super(symbols, tokens, null);
    }

    @Deprecated
    public TryParserManager(Symbols symbols, TokenIterator tokens, MarkerList markers) {
        super(symbols, tokens, markers);
    }

    @Override
    public void report(Marker error) {
        boolean isError = error.isError();
        if (!this.hasSyntaxErrors && isError) {
            this.hasSyntaxErrors = true;
        }
        if (this.reportErrors || !isError) {
            super.report(error);
        }
    }

    private void setNextAndReset(IToken token) {
        this.reset();
        this.tokens.setNext(token);
        if (this.splitTokens == null || this.splitTokens.isEmpty()) {
            return;
        }
        for (IToken splitToken : this.splitTokens) {
            splitToken.prev().setNext(splitToken);
            splitToken.next().setPrev(splitToken);
        }
        this.splitTokens.clear();
    }

    @Override
    public IToken split(IToken token, int length) {
        IToken split = super.split(token, length);
        if (split == token) {
            return token;
        }
        if (this.splitTokens == null) {
            this.splitTokens = new ArrayList<IToken>();
        }
        this.splitTokens.add(token);
        return split;
    }

    public boolean tryParse(IParserManager pm, Parser parser, IToken token, int flags) {
        TokenIterator tokens = pm.getTokens();
        MarkerList markers = pm.getMarkers();
        this.reset(markers, tokens);
        tokens.setNext(token);
        if (!this.parse(parser, markers, flags)) {
            this.setNextAndReset(token);
            return false;
        }
        this.reset();
        tokens.setNext(tokens.lastReturned());
        return true;
    }

    @Override
    @Deprecated
    public void parse(Parser parser) {
        this.parse(parser, this.markers, 0);
    }

    public boolean parse(Parser parser, MarkerList markers, int flags) {
        IToken token;
        block10: {
            this.parser = parser;
            this.hasSyntaxErrors = false;
            this.markers = new MarkerList(markers.getI18n());
            this.reportErrors = (flags & 1) != 0;
            token = null;
            while (true) {
                if (this.reparse) {
                    this.reparse = false;
                } else {
                    token = this.tokens.next();
                    if (token.type() == 0) break block10;
                }
                if (this.skip > 0) {
                    --this.skip;
                    continue;
                }
                if (this.parser == null) {
                    if ((flags & 2) != 0) {
                        return this.success(markers);
                    }
                    this.reportUnparsed(token);
                    continue;
                }
                if (!this.reportErrors && this.parser.reportErrors()) {
                    if (this.hasSyntaxErrors) {
                        return this.success(markers);
                    }
                    this.reportErrors = true;
                }
                try {
                    this.parser.parse(this, token);
                }
                catch (Exception ex) {
                    this.reportError(token, ex);
                    return this.success(markers);
                }
                if (this.hasSyntaxErrors && !this.reportErrors) break;
            }
            return this.success(markers);
        }
        this.parseRemaining(token);
        this.reparse = false;
        return this.success(markers);
    }

    private boolean success(MarkerList markers) {
        if (!this.hasSyntaxErrors || this.reportErrors) {
            markers.addAll(this.markers);
            return true;
        }
        return false;
    }
}

