/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.List;
import dyvil.collection.mutable.ArrayList;
import dyvil.lang.Objects;
import dyvil.lang.Output;
import dyvilx.tools.gensrc.Builtins;
import dyvilx.tools.gensrc.Specialization;
import dyvilx.tools.gensrc.spec.DefaultSpec;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

@ClassParameters(names={"name"})
public abstract class Template {
    protected final @NonNull String name;
    protected @NonNull File outputDir = new File(".");
    protected final @NonNull List<@NonNull Specialization> specs = new ArrayList<Specialization>();

    @DyvilName(value="outputDir")
    public @NonNull File getOutputDir() {
        return this.outputDir;
    }

    @DyvilName(value="outputDir_$eq")
    public void setOutputDir(@NonNull File newValue) {
        this.outputDir = newValue;
    }

    public Template(@NonNull String name) {
        this.name = name;
    }

    @DyvilName(value="pathPrefix")
    public @NonNull String getPathPrefix() {
        String string;
        int index = this.name.lastIndexOf("/");
        if (index < 0) {
            string = "";
        } else {
            String string2 = this.name.substring(0, index + 1);
            string = string2;
            string2.getClass();
        }
        return string;
    }

    @DyvilName(value="fileName")
    public @NonNull String getFileName() {
        return Template.getFileName(this.name);
    }

    private static @NonNull String getFileName(@NonNull String name) {
        String string;
        int index = name.lastIndexOf(".");
        if (index < 0) {
            string = name;
        } else {
            String string2 = name.substring(0, index);
            string = string2;
            string2.getClass();
        }
        return string;
    }

    public static boolean nameMatches(@NonNull String templateName, @NonNull String specName) {
        return specName.contains(Template.getFileName(templateName));
    }

    public void addSpec(@NonNull String specName) {
        if (!Template.nameMatches(this.name, specName)) {
            return;
        }
        try {
            this.specs.add(Builtins.spec(specName));
        }
        catch (IOException iOException) {}
    }

    public @NonNull Specialization spec(@NonNull String name) throws @NonNull IOException {
        for (Specialization spec : this.specs) {
            if (!Objects.equals(spec.getFile().getName(), name)) continue;
            return spec;
        }
        return Builtins.spec(name);
    }

    public void mainImpl(@NonNull String @NonNull [] args) {
        String[] stringArray = args;
        int n = stringArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                String arg;
                if ((arg = stringArray[n2]).startsWith("output_dir=")) {
                    this.outputDir = new File(arg.substring(11));
                    continue;
                }
                if (arg.startsWith("source_dir=")) {
                    String string = arg.substring(11);
                    string.getClass();
                    Builtins.addSourceDir(string);
                    continue;
                }
                this.addSpec(arg);
            } while (++n2 < n);
        }
        this.generate();
    }

    /*
     * WARNING - void declaration
     */
    public int generate() {
        void var1_2;
        this.outputDir.mkdirs();
        if (this.specs.isEmpty()) {
            try {
                this.generate(DefaultSpec.instance);
                Output.print(new StringBuilder(52).append("Generated source for template '").append(this.name).append("'").toString());
            }
            catch (IOException count) {
                Output.print(new StringBuilder(61).append("Failed to generate source for template '").append(this.name).append("'").toString());
                count.printStackTrace();
            }
            return 1;
        }
        int count = 0;
        for (Specialization spec : this.specs) {
            try {
                if (!this.generate(spec)) continue;
                ++count;
            }
            catch (IOException iOException) {
                Output.print(new StringBuilder(82).append("Failed to generate spec '").append(spec).append("' for template '").append(this.name).append("'").toString());
                iOException.printStackTrace();
            }
        }
        Output.print(new StringBuilder(74).append("Generated ").append(count).append(" spec(s) for template '").append(this.name).append("'").toString());
        return (int)var1_2;
    }

    public boolean generate(@NonNull Specialization spec) throws @NonNull IOException {
        String fileName = spec.subscript("@enabled");
        if (fileName != null && !Boolean.parseBoolean(fileName)) {
            return false;
        }
        fileName = spec.subscript("@fileName");
        fileName = fileName != null ? this.getPathPrefix().concat(fileName) : this.getFileName();
        File outputFile = new File(this.outputDir, fileName);
        outputFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(outputFile);
        try {
            this.generate(spec, writer);
        }
        catch (IOException iOException) {
            writer.close();
            throw iOException;
        }
        writer.close();
        return true;
    }

    public abstract void generate(@NonNull Specialization var1, @NonNull Writer var2) throws @NonNull IOException;
}

