/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.List;
import dyvil.collection.mutable.ArrayList;
import dyvil.lang.Output;
import dyvilx.tools.gensrc.Builtins;
import dyvilx.tools.gensrc.Template;
import java.io.File;

public class Runner {
    public static void main(@NonNull String @NonNull [] args) {
        String basePath = new File(".").getAbsolutePath();
        Output.print(new StringBuilder(62).append("Generating sources from templates in '").append((Object)basePath).append("'...").toString());
        int specs = 0;
        List<Template> templates = Runner.parseTemplates(args);
        for (Template temp : templates) {
            specs += temp.generate();
        }
        Output.print(new StringBuilder(88).append("Generated sources for ").append(templates.size()).append(" template(s) and ").append(specs).append(" spec(s).").toString());
    }

    private static @NonNull List<@NonNull Template> parseTemplates(@NonNull String @NonNull [] args) {
        int argc = args.length;
        File outputDir = new File(".");
        Template currentTemplate = null;
        ArrayList<Template> templates = new ArrayList<Template>();
        int n = argc;
        for (int i = 0; i < n; ++i) {
            String arg = args[i];
            if (arg.startsWith("output_dir=")) {
                outputDir = new File(arg.substring(11));
                continue;
            }
            if (arg.startsWith("source_dir=")) {
                String string = arg.substring(11);
                string.getClass();
                Builtins.addSourceDir(string);
                continue;
            }
            if (arg.equals("-t") && i < argc - 1) {
                String tempName = args[i + 1];
                currentTemplate = (Template)Class.forName(tempName).newInstance();
                currentTemplate.setOutputDir(outputDir);
                Template template = currentTemplate;
                template.getClass();
                templates.add(template);
                ++i;
                continue;
            }
            currentTemplate.addSpec(arg);
        }
        return templates;
    }
}

