/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.List;
import dyvil.collection.Map;
import dyvil.collection.mutable.ArrayList;
import dyvil.collection.mutable.HashMap;
import dyvil.function.Function;
import dyvil.io.Files;
import dyvil.lang.Strings;
import dyvilx.tools.gensrc.Specialization;
import dyvilx.tools.gensrc.spec.PropertySpec;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;

public abstract class Builtins {
    public static final @NonNull String GEN_NOTICE = "GENERATED SOURCE - DO NOT EDIT";
    public static final @NonNull String TIME_STAMP = Builtins.timeStamp();
    private static final @NonNull List<@NonNull String> SOURCE_DIRS = new ArrayList<String>();
    private static final @NonNull Map<@NonNull String, @NonNull Specialization> SPEC_MAP = new HashMap<String, Specialization>();

    private Builtins() {
    }

    public static @NonNull String timeStamp() {
        String string = LocalDateTime.now().toString();
        string.getClass();
        return string;
    }

    public static @NonNull String timeStamp(@NonNull String format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        dateTimeFormatter.getClass();
        return Builtins.timeStamp(dateTimeFormatter);
    }

    public static @NonNull String timeStamp(@NonNull DateTimeFormatter formatter) {
        String string = LocalDateTime.now().format(formatter);
        string.getClass();
        return string;
    }

    protected static void addSourceDir(@NonNull String dir) {
        SOURCE_DIRS.add(dir);
    }

    public static @NonNull File file(@NonNull String name) {
        for (String srcDir : SOURCE_DIRS) {
            File file = new File(srcDir, name);
            if (!file.exists()) continue;
            return file;
        }
        return new File(name);
    }

    public static @NonNull Specialization spec(@NonNull String name) throws @NonNull IOException {
        return Builtins.spec(Builtins.file(name));
    }

    public static @NonNull Specialization spec(@NonNull File file) throws @NonNull IOException {
        String canonPath = file.getCanonicalPath();
        Object input = SPEC_MAP.subscript(canonPath);
        if (input != null) {
            return input;
        }
        input = new BufferedInputStream(new FileInputStream(file));
        Properties props = new Properties();
        try {
            props.load((InputStream)input);
        }
        catch (IOException spec) {
            ((BufferedInputStream)input).close();
            throw spec;
        }
        ((BufferedInputStream)input).close();
        PropertySpec spec = new PropertySpec(file, props);
        String string = canonPath;
        string.getClass();
        SPEC_MAP.put(string, spec);
        return spec;
    }

    public static @NonNull String include(@NonNull String name) throws @NonNull IOException {
        return Builtins.include(Builtins.file(name));
    }

    public static @NonNull String include(@NonNull File file) throws @NonNull IOException {
        return Files.readText(file);
    }

    public static @NonNull String decorate(@NonNull Function.Of1<@NonNull String, @NonNull String> process, @NonNull String body) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = body.split("\n");
        int n = stringArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                String line;
                String string = line = stringArray[n2];
                string.getClass();
                result.append(process.apply(string)).append("\n");
            } while (++n2 < n);
        }
        String string = result.toString();
        string.getClass();
        string.getClass();
        return string;
    }

    public static @NonNull String replace(@NonNull String target, @NonNull String replacement, @NonNull String body) {
        String string = body.replace(target, replacement);
        string.getClass();
        string.getClass();
        return string;
    }

    public static @NonNull String replaceAll(@NonNull String target, @NonNull String replacement, @NonNull String body) {
        String string = body.replaceAll(target, replacement);
        string.getClass();
        string.getClass();
        return string;
    }

    public static @NonNull String replaceAll(@NonNull String target, @NonNull Function.Of1<@NonNull String, @NonNull String> replacer, @NonNull String body) {
        return Strings.replaceAll(body, target, replacer);
    }
}

