/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.asm;

public class TypeReference {
    public static final int CLASS_TYPE_PARAMETER = 0;
    public static final int METHOD_TYPE_PARAMETER = 1;
    public static final int CLASS_EXTENDS = 16;
    public static final int CLASS_TYPE_PARAMETER_BOUND = 17;
    public static final int METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int FIELD = 19;
    public static final int METHOD_RETURN = 20;
    public static final int METHOD_RECEIVER = 21;
    public static final int METHOD_FORMAL_PARAMETER = 22;
    public static final int THROWS = 23;
    public static final int LOCAL_VARIABLE = 64;
    public static final int RESOURCE_VARIABLE = 65;
    public static final int EXCEPTION_PARAMETER = 66;
    public static final int INSTANCEOF = 67;
    public static final int NEW = 68;
    public static final int CONSTRUCTOR_REFERENCE = 69;
    public static final int METHOD_REFERENCE = 70;
    public static final int CAST = 71;
    public static final int CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    public static final int METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    public static final int CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    public static final int METHOD_REFERENCE_TYPE_ARGUMENT = 75;

    public static int newTypeReference(int sort) {
        return sort << 24;
    }

    public static int newTypeParameterReference(int sort, int paramIndex) {
        return sort << 24 | paramIndex << 16;
    }

    public static int newTypeParameterBoundReference(int sort, int paramIndex, int boundIndex) {
        return sort << 24 | paramIndex << 16 | boundIndex << 8;
    }

    public static int newSuperTypeReference(int itfIndex) {
        return 0x10000000 | (itfIndex &= 0xFFFF) << 8;
    }

    public static int newFormalParameterReference(int paramIndex) {
        return 0x16000000 | paramIndex << 16;
    }

    public static int newExceptionReference(int exceptionIndex) {
        return 0x17000000 | exceptionIndex << 8;
    }

    public static int newTryCatchReference(int tryCatchBlockIndex) {
        return 0x42000000 | tryCatchBlockIndex << 8;
    }

    public static int newTypeArgumentReference(int sort, int argIndex) {
        return sort << 24 | argIndex;
    }

    public static int getSort(int value) {
        return value >>> 24;
    }

    public static int getTypeParameterIndex(int value) {
        return (value & 0xFF0000) >> 16;
    }

    public static int getTypeParameterBoundIndex(int value) {
        return (value & 0xFF00) >> 8;
    }

    public static int getSuperTypeIndex(int value) {
        return (short)((value & 0xFFFF00) >> 8);
    }

    public static int getFormalParameterIndex(int value) {
        return (value & 0xFF0000) >> 16;
    }

    public static int getExceptionIndex(int value) {
        return (value & 0xFFFF00) >> 8;
    }

    public static int getTryCatchBlockIndex(int value) {
        return (value & 0xFFFF00) >> 8;
    }

    public static int getTypeArgumentIndex(int value) {
        return value & 0xFF;
    }
}

