/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.event;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.List;
import dyvil.collection.mutable.ArrayList;
import dyvil.reflect.Modifiers;
import dyvilx.event.EventBus;
import dyvilx.event.EventHandler;
import dyvilx.event.HandlerEntry;
import java.lang.reflect.Method;

public class InvariantEventBus
implements EventBus {
    protected final @NonNull List<@NonNull HandlerEntry> handlers = new ArrayList<HandlerEntry>();

    @Override
    public void register(Object handler, @NonNull Class<? extends @Primitive Object> ofType) {
        HandlerEntry entry = HandlerEntry.apply(handler, ofType);
        this.handlers.add(entry);
        Method[] methodArray = ofType.getDeclaredMethods();
        int n = methodArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                Class<?> parameterType;
                Method method;
                if ((method = methodArray[n2]).getParameterCount() != 1 || method.getAnnotation(EventHandler.class) == null || (method.getModifiers() & Modifiers.STATIC) == 0 && handler == null) continue;
                Class<?>[] classArray = method.getParameterTypes();
                classArray.getClass();
                Class<?> clazz = parameterType = classArray[0];
                clazz.getClass();
                Method method2 = method;
                method2.getClass();
                entry.addHandler(clazz, method2);
            } while (++n2 < n);
        }
    }

    @Override
    public void dispatch(@NonNull Object event) {
        Class<?> eventType = event.getClass();
        for (HandlerEntry entry : this.handlers) {
            Method method = entry.getHandler(eventType);
            if (method == null) continue;
            this.invoke(method, entry.getHandler(), event);
        }
    }

    protected final void invoke(@NonNull Method method, Object handler, @NonNull Object event) {
        try {
            method.setAccessible(true);
            method.invoke(handler, event);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

