/*
 * Decompiled with CFR 0.152.
 */
package dyvil.util;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.lang.LiteralConvertible;
import dyvil.lang.Objects;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
@LiteralConvertible.FromString
@LiteralConvertible.FromTuple
@ClassParameters(names={"major", "minor", "patch", "prerelease", "build"})
public final class Version
implements Comparable<Version>,
Serializable {
    protected final int major;
    protected final int minor;
    protected final int patch;
    protected final @Nullable String prerelease;
    protected final @Nullable String build;
    protected static final long serialVersionUID = 2514051844985966173L;
    protected static final @NonNull String INFO_FORMAT = "[\\dA-Za-z\\-]+(?:\\.[\\dA-Za-z\\-]+)*";
    protected static final @NonNull Pattern INFO_PATTERN;
    protected static final @NonNull String FORMAT;
    protected static final @NonNull Pattern PATTERN;

    public static String apply$paramDefault$prerelease() {
        return null;
    }

    public static String apply$paramDefault$build() {
        return null;
    }

    public Version(int major, int minor, int patch, @Nullable String prerelease, @Nullable String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.build = build;
    }

    public static @NonNull Version apply(int major, int minor, int patch) {
        return Version.apply(major, minor, patch, null, null);
    }

    public static @NonNull Version apply(int major, int minor, int patch, @DyvilModifiers(value=131072L) @Nullable String prerelease, @DyvilModifiers(value=131072L) @Nullable String build) {
        if (major < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("").append((Object)Element.MAJOR).append(" must not be negative").toString());
        }
        if (minor < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("").append((Object)Element.MINOR).append(" must not be negative").toString());
        }
        if (patch < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("").append((Object)Element.PATCH).append(" must not be negative").toString());
        }
        if (prerelease != null && !INFO_PATTERN.matcher(prerelease).find()) {
            throw new IllegalArgumentException(new StringBuilder(78).append("").append((Object)Element.PRERELEASE).append(" '").append((Object)prerelease).append("' does not match format '").append(INFO_FORMAT).append("'").toString());
        }
        if (build != null && !INFO_PATTERN.matcher(build).find()) {
            throw new IllegalArgumentException(new StringBuilder(73).append("").append((Object)Element.BUILD).append(" '").append((Object)build).append("' does not match format '").append(INFO_FORMAT).append("'").toString());
        }
        return new Version(major, minor, patch, prerelease, build);
    }

    public static @NonNull Version apply(@NonNull String version) {
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(new StringBuilder(67).append("'").append(version).append("' does not match format '").append(FORMAT).append("'").toString());
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String prerelease = matcher.group(4);
        String build = matcher.group(5);
        return new Version(major, minor, patch, prerelease, build);
    }

    public @Nullable String releaseInfo() {
        return this.prerelease;
    }

    public @Nullable String buildInfo() {
        return this.build;
    }

    public boolean isInDevelopment() {
        return this.major == 0;
    }

    public boolean isStable() {
        return this.major > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public @NonNull Version next(@NonNull Element element) {
        Element element2 = element;
        switch (element2.name().hashCode()) {
            case 73121177: {
                if (element2 != Element.MAJOR) throw new IllegalArgumentException("Only major, minor or patch can be incremented");
                Version version = new Version(this.major + 1, 0, 0, null, null);
                return version;
            }
            case 73363349: {
                if (element2 != Element.MINOR) throw new IllegalArgumentException("Only major, minor or patch can be incremented");
                Version version = new Version(this.major, this.minor + 1, 0, null, null);
                return version;
            }
            case 75900968: {
                if (element2 != Element.PATCH) throw new IllegalArgumentException("Only major, minor or patch can be incremented");
                Version version = new Version(this.major, this.minor, this.patch + 1, null, null);
                return version;
            }
            default: {
                throw new IllegalArgumentException("Only major, minor or patch can be incremented");
            }
        }
    }

    public @NonNull String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (this.prerelease != null) {
            stringBuilder.append("-").append(this.prerelease);
        }
        if (this.build != null) {
            stringBuilder.append("+").append(this.build);
        }
        String string = stringBuilder.toString();
        string.getClass();
        return string;
    }

    public boolean equals(@Primitive Object obj) {
        return this == obj || obj instanceof Version && this.equals((Version)obj);
    }

    public boolean equals(@NonNull Version that) {
        return this == that || this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equals(this.prerelease, that.prerelease);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var2_2;
        int prime = 31;
        int result = 1;
        result = prime * result + this.major;
        result = prime * result + this.minor;
        result = prime * result + this.patch;
        String string = this.prerelease;
        result = prime * result + (string != null ? string.hashCode() : 0);
        return (int)var2_2;
    }

    @Override
    public int compareTo(@NonNull Version o) {
        int cmp = this.major - o.major;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.minor - o.minor;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.patch - o.patch;
        if (cmp != 0) {
            return cmp;
        }
        if (this.prerelease == null) {
            return o.prerelease != null ? -1 : 0;
        }
        if (o.prerelease == null) {
            return 1;
        }
        return this.prerelease.compareTo(o.prerelease);
    }

    static {
        Pattern pattern = Pattern.compile(INFO_FORMAT);
        pattern.getClass();
        INFO_PATTERN = pattern;
        FORMAT = new StringBuilder(80).append("^v?(\\d+)\\.(\\d+)\\.(\\d+)(?:-(").append(INFO_FORMAT).append("))?(?:\\+(").append(INFO_FORMAT).append("))?$").toString();
        Pattern pattern2 = Pattern.compile(FORMAT);
        pattern2.getClass();
        PATTERN = pattern2;
    }

    public static enum Element {
        MAJOR,
        MINOR,
        PATCH,
        PRERELEASE,
        BUILD;


        @DyvilName(value="from")
        public static @NonNull Element valueOf(@NonNull String name) {
            return Enum.valueOf(Element.class, name);
        }
    }
}

