/*
 * Decompiled with CFR 0.152.
 */
package dyvil.util;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.function.Function;
import dyvil.tuple.Tuple;

public final class Timing {
    private Timing() {
    }

    public static long measureMillis(@NonNull Function.Of0<@Primitive Void> f) {
        return Timing.measureMillis(1, f);
    }

    public static long measureMillis(int iterations, @NonNull Function.Of0<@Primitive Void> f) {
        long start = System.currentTimeMillis();
        int n = iterations;
        for (int i = 0; i < n; ++i) {
            f.apply();
        }
        return (System.currentTimeMillis() - start) / (long)iterations;
    }

    public static long measureNanos(@NonNull Function.Of0<@Primitive Void> f) {
        return Timing.measureNanos(1, f);
    }

    public static long measureNanos(int iterations, @NonNull Function.Of0<@Primitive Void> f) {
        long start = System.nanoTime();
        int n = iterations;
        for (int i = 0; i < n; ++i) {
            f.apply();
        }
        return (System.nanoTime() - start) / (long)iterations;
    }

    public static <R> @NonNull Tuple.Of2<R, @Primitive Long> milliTimed(@NonNull Function.Of0<R> f) {
        long l = System.currentTimeMillis();
        return new Tuple.Of2<R, Long>(f.apply(), System.currentTimeMillis() - l);
    }

    public static <R> @NonNull Tuple.Of2<R, @Primitive Long> nanoTimed(@NonNull Function.Of0<R> f) {
        long l = System.nanoTime();
        return new Tuple.Of2<R, Long>(f.apply(), System.nanoTime() - l);
    }
}

