/*
 * Decompiled with CFR 0.152.
 */
package dyvil.util;

import dyvil.annotation.Immutable;
import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.function.Function;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import dyvil.util.None;
import dyvil.util.Option;

@DyvilModifiers(value=131072L)
@Immutable
@LiteralConvertible.FromTuple
@ClassParameters(names={"value"})
public class Some<@Covariant T>
implements Option<T> {
    protected final T value;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Some some = (Some)object;
        return this.value.equals(some.value);
    }

    public int hashCode() {
        T t = this.value;
        return (31 + (t != null ? t.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "Some(" + this.value + ")";
    }

    @DyvilName(value="value")
    public T getValue() {
        return this.value;
    }

    public Some(T value) {
        this.value = value;
    }

    public static final <T> @Nullable Tuple.Of1<T> unapply(Option<T> option) {
        return option instanceof Some ? Some.unapply((Some)option) : null;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public void forEach(@NonNull Function.Of1<T, @Primitive Void> action) {
        action.apply(this.value);
    }

    @Override
    public @NonNull Option<T> filter(@NonNull Function.Of1<T, @Primitive Boolean> predicate) {
        return predicate.apply(this.value) != false ? this : None.instance;
    }

    @Override
    public <U> @NonNull Option<U> map(@NonNull Function.Of1<T, U> mapper) {
        return Some.apply(mapper.apply(this.value));
    }

    @Override
    public <U> @NonNull Option<U> flatMap(@NonNull Function.Of1<T, @NonNull Option<U>> mapper) {
        return mapper.apply(this.value);
    }

    @Override
    public <U> T orElse(U value) {
        return this.value;
    }

    @Override
    @OverloadPriority
    public <U> T orElse(@NonNull Function.Of0<U> supplier) {
        return this.value;
    }

    public static final <T> @NonNull Some<T> apply(T value) {
        return new Some<T>(value);
    }

    public static final <T> @NonNull Tuple.Of1<T> unapply(@NonNull Some<T> value) {
        return new Tuple.Of1<T>(value.value);
    }

    public static final <T> @Nullable Tuple.Of1<T> unapply(@Primitive Object value) {
        return value instanceof Some ? Some.unapply((Some)value) : null;
    }
}

