/*
 * Decompiled with CFR 0.152.
 */
package dyvil.util;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;

public class Qualifier {
    public static final @NonNull Qualifier INSTANCE = new Qualifier();
    public static final @NonNull String AMPERSAND = "amp";
    public static final @NonNull String ASTERISK = "times";
    public static final @NonNull String AT = "at";
    public static final @NonNull String BACKSLASH = "bslash";
    public static final @NonNull String BAR = "bar";
    public static final @NonNull String CARET = "up";
    public static final @NonNull String COLON = "colon";
    public static final @NonNull String DOT = "dot";
    public static final @NonNull String EQ = "eq";
    public static final @NonNull String EXCLAMATION = "bang";
    public static final @NonNull String GREATER = "gt";
    public static final @NonNull String HASH = "hash";
    public static final @NonNull String LESS = "lt";
    public static final @NonNull String MINUS = "minus";
    public static final @NonNull String PERCENT = "percent";
    public static final @NonNull String PLUS = "plus";
    public static final @NonNull String QUESTION_MARK = "qmark";
    public static final @NonNull String SLASH = "div";
    public static final @NonNull String TILDE = "tilde";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int replaceString(@NonNull String s) {
        String string = s;
        switch (string.hashCode()) {
            case -1379791269: {
                if (!BACKSLASH.equals(string)) return 0;
                return 92;
            }
            case -678927291: {
                if (!PERCENT.equals(string)) return 0;
                return 37;
            }
            case 3123: {
                if (!AT.equals(string)) return 0;
                return 64;
            }
            case 3244: {
                if (!EQ.equals(string)) return 0;
                return 61;
            }
            case 3309: {
                if (!GREATER.equals(string)) return 0;
                return 62;
            }
            case 3464: {
                if (!LESS.equals(string)) return 0;
                return 60;
            }
            case 3739: {
                if (!CARET.equals(string)) return 0;
                return 94;
            }
            case 96708: {
                if (!AMPERSAND.equals(string)) return 0;
                return 38;
            }
            case 97299: {
                if (!BAR.equals(string)) return 0;
                return 124;
            }
            case 99473: {
                if (!SLASH.equals(string)) return 0;
                return 47;
            }
            case 99657: {
                if (!DOT.equals(string)) return 0;
                return 46;
            }
            case 3016248: {
                if (!EXCLAMATION.equals(string)) return 0;
                return 33;
            }
            case 3195150: {
                if (!HASH.equals(string)) return 0;
                return 35;
            }
            case 3444122: {
                if (!PLUS.equals(string)) return 0;
                return 43;
            }
            case 94842719: {
                if (!COLON.equals(string)) return 0;
                return 58;
            }
            case 103901296: {
                if (!MINUS.equals(string)) return 0;
                return 45;
            }
            case 0x66B66BE: {
                if (!QUESTION_MARK.equals(string)) return 0;
                return 63;
            }
            case 110363480: {
                if (!TILDE.equals(string)) return 0;
                return 126;
            }
            case 110364486: {
                if (!ASTERISK.equals(string)) return 0;
                return 42;
            }
            default: {
                return 0;
            }
        }
    }

    public @Nullable String replaceCodePoint(int c) {
        String string;
        switch (c) {
            case 33: {
                string = EXCLAMATION;
                break;
            }
            case 35: {
                string = HASH;
                break;
            }
            case 37: {
                string = PERCENT;
                break;
            }
            case 38: {
                string = AMPERSAND;
                break;
            }
            case 42: {
                string = ASTERISK;
                break;
            }
            case 43: {
                string = PLUS;
                break;
            }
            case 45: {
                string = MINUS;
                break;
            }
            case 46: {
                string = DOT;
                break;
            }
            case 47: {
                string = SLASH;
                break;
            }
            case 58: {
                string = COLON;
                break;
            }
            case 60: {
                string = LESS;
                break;
            }
            case 61: {
                string = EQ;
                break;
            }
            case 62: {
                string = GREATER;
                break;
            }
            case 63: {
                string = QUESTION_MARK;
                break;
            }
            case 64: {
                string = AT;
                break;
            }
            case 92: {
                string = BACKSLASH;
                break;
            }
            case 94: {
                string = CARET;
                break;
            }
            case 124: {
                string = BAR;
                break;
            }
            case 126: {
                string = TILDE;
                break;
            }
            default: {
                string = null;
                break;
            }
        }
        return string;
    }

    public static @NonNull String qualify(@NonNull String string) {
        return Qualifier.qualify(string, INSTANCE);
    }

    public static @NonNull String qualify(@NonNull String string, @NonNull Qualifier qualifier) {
        int codePoint;
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            String replacement = qualifier.replaceCodePoint(codePoint);
            if (replacement != null) {
                builder.append("$").append(replacement);
                continue;
            }
            builder.appendCodePoint(codePoint);
        }
        String string2 = builder.toString();
        string2.getClass();
        string2.getClass();
        return string2;
    }

    public static @NonNull String unqualify(@NonNull String string) {
        return Qualifier.unqualify(string, INSTANCE);
    }

    public static @NonNull String unqualify(@NonNull String string, @NonNull Qualifier qualifier) {
        int cashIndex;
        int appendStart = string.indexOf("$");
        if (appendStart < 0) {
            return string;
        }
        int len = string.length();
        StringBuilder builder = new StringBuilder(len);
        builder.append(string, 0, appendStart);
        int searchIndex = appendStart;
        while (searchIndex < len && (cashIndex = string.indexOf("$", searchIndex)) >= 0) {
            String key;
            int endIndex;
            int startIndex = cashIndex + 1;
            searchIndex = endIndex = Qualifier.symbolEndIndex(string, startIndex, len);
            if (startIndex == endIndex) continue;
            String string2 = key = string.substring(startIndex, endIndex);
            string2.getClass();
            int replacement = qualifier.replaceString(string2);
            if (replacement <= 0) continue;
            builder.append(string, appendStart, cashIndex);
            builder.appendCodePoint(replacement);
            appendStart = endIndex;
        }
        builder.append(string, appendStart, len);
        String string3 = builder.toString();
        string3.getClass();
        string3.getClass();
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static int symbolEndIndex(@NonNull String string, int start, int end) {
        void var2_2;
        while (start < end) {
            switch (string.charAt(start)) {
                case '$': {
                    return start;
                }
                case '_': {
                    return start;
                }
            }
            ++start;
        }
        return (int)var2_2;
    }
}

