/*
 * Decompiled with CFR 0.152.
 */
package dyvil.string;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;

@ClassParameters(names={"array", "start", "length"})
public class CharArrayView
implements CharSequence {
    protected final char @NonNull [] array;
    protected final int start;
    protected final int length;

    public CharArrayView(char @NonNull [] array) {
        this(array, 0, array.length);
    }

    public CharArrayView(char @NonNull [] array, int start, int length) {
        this.array = array;
        this.start = start;
        this.length = length;
    }

    @DyvilModifiers(value=0x200000L)
    public static @NonNull CharArrayView apply(char @NonNull [] array) {
        return new CharArrayView(array);
    }

    public static @NonNull CharArrayView apply(char @NonNull [] array, int start, int length) {
        return new CharArrayView(array, start, length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.array[this.start + index];
    }

    @Override
    public @NonNull CharSequence subSequence(int start, int end) {
        return new CharArrayView(this.array, this.start + start, end - start);
    }

    @Override
    public @NonNull String toString() {
        return new String(this.array, this.start, this.length);
    }
}

