/*
 * Decompiled with CFR 0.152.
 */
package dyvil.source.position;

import dyvil.annotation.Deprecated;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import java.util.Objects;

public interface SourcePosition
extends Comparable<SourcePosition> {
    public static final int FIRST_LINE = 1;
    public static final int FIRST_COLUMN = 0;
    public static final @NonNull SourcePosition ORIGIN = SourcePosition.apply(FIRST_LINE, FIRST_COLUMN);

    public int startLine();

    public int endLine();

    public int startColumn();

    public int endColumn();

    @DyvilModifiers(value=131072L)
    public static @NonNull SourcePosition $dot$dot(@NonNull SourcePosition lhs, @NonNull SourcePosition rhs) {
        return new Base(lhs.startLine(), rhs.endLine(), lhs.startColumn(), rhs.endColumn());
    }

    public static @NonNull SourcePosition apply(int startLine, int endLine, int startColumn, int endColumn) {
        return new Base(startLine, endLine, startColumn, endColumn);
    }

    public static @NonNull SourcePosition apply(int line, int startColumn, int endColumn) {
        return new Base(line, line, startColumn, endColumn);
    }

    public static @NonNull SourcePosition apply(int line, int column) {
        return new Base(line, line, column, column + 1);
    }

    @DyvilName(value="apply")
    public static @NonNull SourcePosition before(@NonNull SourcePosition position) {
        int column = position.startColumn();
        return SourcePosition.apply(position.startLine(), column <= FIRST_COLUMN ? FIRST_COLUMN : column - 1);
    }

    @DyvilName(value="apply")
    public static @NonNull SourcePosition after(@NonNull SourcePosition position) {
        return SourcePosition.apply(position.endLine(), position.endColumn());
    }

    @DyvilName(value="apply")
    public static @NonNull SourcePosition between(@NonNull SourcePosition start, @NonNull SourcePosition end) {
        int endColumn;
        int startColumn = start.endColumn();
        if (startColumn == (endColumn = end.startColumn())) {
            ++startColumn;
            --endColumn;
        }
        return new Base(start.endLine(), end.startLine(), startColumn, endColumn);
    }

    default public @NonNull SourcePosition raw() {
        return new Base(this.startLine(), this.endLine(), this.startColumn(), this.endColumn());
    }

    @Deprecated(replacements={"SourcePosition.`..`(SourcePosition)"})
    default public @NonNull SourcePosition to(@NonNull SourcePosition end) {
        return SourcePosition.$dot$dot(this, end);
    }

    @Override
    default public int compareTo(@NonNull SourcePosition o) {
        int byLine = Integer.valueOf(this.startLine()).compareTo(o.startLine());
        if (byLine != 0) {
            return byLine;
        }
        return Integer.valueOf(this.startColumn()).compareTo(o.startColumn());
    }

    @Deprecated
    default public boolean isBefore(@NonNull SourcePosition position) {
        return this.compareTo(position) < 0;
    }

    @Deprecated
    default public boolean isAfter(@NonNull SourcePosition position) {
        return this.compareTo(position) > 0;
    }

    default public boolean isNeighboring(@NonNull SourcePosition position) {
        return this.endLine() == position.startLine() && this.endColumn() == position.startColumn();
    }

    default public @NonNull String toPositionString() {
        int endColumn = this.endColumn() - 1;
        if (this.startLine() != this.endLine()) {
            return new StringBuilder(83).append("").append(this.startLine()).append(".").append(this.startColumn()).append("-").append(this.endLine()).append(".").append(endColumn).append("").toString();
        }
        if (this.startColumn() != endColumn) {
            return new StringBuilder(62).append("").append(this.startLine()).append(".").append(this.startColumn()).append("-").append(endColumn).append("").toString();
        }
        return new StringBuilder(41).append("").append(this.startLine()).append(".").append(this.startColumn()).append("").toString();
    }

    @ClassParameters(names={"startLine", "endLine", "startColumn", "endColumn"})
    private static class Base
    implements SourcePosition {
        protected final int startLine;
        protected final int endLine;
        protected final int startColumn;
        protected final int endColumn;

        @Override
        public int startLine() {
            return this.startLine;
        }

        @Override
        public int endLine() {
            return this.endLine;
        }

        @Override
        public int startColumn() {
            return this.startColumn;
        }

        @Override
        public int endColumn() {
            return this.endColumn;
        }

        public Base(int startLine, int endLine, int startColumn, int endColumn) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.startColumn = startColumn;
            this.endColumn = endColumn;
        }

        @Override
        public @NonNull SourcePosition raw() {
            return this;
        }

        public boolean equals(@NonNull SourcePosition that) {
            if (this == that) {
                return true;
            }
            if (this.startLine != that.startLine()) {
                return false;
            }
            if (this.endLine != that.endLine()) {
                return false;
            }
            if (this.startColumn != that.startColumn()) {
                return false;
            }
            return this.endColumn == that.endColumn();
        }

        public boolean equals(@Primitive Object obj) {
            return this == obj || obj instanceof SourcePosition && this.equals((SourcePosition)obj);
        }

        public int hashCode() {
            return Objects.hash(this.startLine, this.endLine, this.startColumn, this.endColumn);
        }

        public @NonNull String toString() {
            return this.toPositionString();
        }
    }
}

