/*
 * Decompiled with CFR 0.152.
 */
package dyvil.source;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.array.IntArray;
import dyvil.source.Source;
import dyvil.tuple.Tuple;
import java.io.Serializable;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"text"})
public class TextSource
implements Source,
Serializable {
    protected final @NonNull String text;
    protected static final int EXPECTED_LINE_LENGTH = 80;
    protected int[] _lineStarts;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TextSource textSource = (TextSource)object;
        return this.text.equals(textSource.text);
    }

    public int hashCode() {
        String string = this.text;
        return (31 + (string != null ? string.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "TextSource(" + this.text + ")";
    }

    @Override
    public @NonNull String text() {
        return this.text;
    }

    public TextSource(@NonNull String text) {
        this.text = text;
    }

    @DyvilName(value="lineStarts")
    public int @NonNull [] getLineStarts() {
        int[] length22 = this._lineStarts;
        if (length22 != null) {
            return length22;
        }
        int length22 = this.text.length();
        int[] lineStarts = new int[length22 / EXPECTED_LINE_LENGTH + 1];
        int lineCount = 1;
        int n = length22;
        block4: for (int i = 0; i < n; ++i) {
            switch (this.text.charAt(i)) {
                case '\n': {
                    lineStarts = TextSource.add(lineStarts, lineCount, i + 1);
                    ++lineCount;
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < length22 && this.text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    lineStarts = TextSource.add(lineStarts, lineCount, i + 1);
                    ++lineCount;
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        this._lineStarts = IntArray.trim(lineStarts, lineCount);
        return this._lineStarts;
    }

    @Override
    public int lineCount() {
        return this.getLineStarts().length;
    }

    private static int @NonNull [] add(int @NonNull [] array, int index, int value) {
        int[] nArray;
        if (index >= array.length) {
            array = IntArray.copy(array, index << 1);
        }
        array[index] = value;
        return nArray;
    }

    private static int lineEnd(@NonNull String text, int index) {
        int n;
        if (index <= 0) {
            return 0;
        }
        switch (text.charAt(index - 1)) {
            case '\n': {
                n = index - (index >= 1 && text.charAt(index - 1) == '\r' ? 2 : 1);
                break;
            }
            case '\r': {
                n = index - 1;
                break;
            }
            default: {
                n = index;
                break;
            }
        }
        return n;
    }

    @Override
    public String line(int index) {
        int[] lineStarts = this.getLineStarts();
        int lineCount = lineStarts.length;
        if (index > lineCount) {
            return null;
        }
        if (index == lineCount) {
            return this.text.substring(lineStarts[index - 1]);
        }
        return this.text.substring(lineStarts[index - 1], TextSource.lineEnd(this.text, lineStarts[index]));
    }

    public static final @NonNull TextSource apply(@NonNull String text) {
        return new TextSource(text);
    }

    public static final @NonNull Tuple.Of1<@NonNull String> unapply(@NonNull TextSource value) {
        return new Tuple.Of1<String>(value.text);
    }

    public static final @Nullable Tuple.Of1<@NonNull String> unapply(@Primitive Object value) {
        return value instanceof TextSource ? TextSource.unapply((TextSource)value) : null;
    }
}

