/*
 * Decompiled with CFR 0.152.
 */
package dyvil.source;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.source.Source;
import dyvil.tuple.Tuple;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"source"})
public class SourceIterator
implements Iterator<String>,
Serializable {
    protected final @NonNull Source source;
    protected int currentLineNumber = 1;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SourceIterator sourceIterator = (SourceIterator)object;
        return this.source.equals(sourceIterator.source);
    }

    public int hashCode() {
        Source source = this.source;
        return (31 + (source != null ? source.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "SourceIterator(" + this.source + ")";
    }

    @DyvilName(value="source")
    public @NonNull Source getSource() {
        return this.source;
    }

    public SourceIterator(@NonNull Source source) {
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        return this.currentLineNumber <= this.source.lineCount();
    }

    @Override
    public @NonNull String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.source.line(this.currentLineNumber);
        string.getClass();
        string.getClass();
        return string;
    }

    public static final @NonNull SourceIterator apply(@NonNull Source source) {
        return new SourceIterator(source);
    }

    public static final @NonNull Tuple.Of1<@NonNull Source> unapply(@NonNull SourceIterator value) {
        return new Tuple.Of1<Source>(value.source);
    }

    public static final @Nullable Tuple.Of1<@NonNull Source> unapply(@Primitive Object value) {
        return value instanceof SourceIterator ? SourceIterator.unapply((SourceIterator)value) : null;
    }
}

