/*
 * Decompiled with CFR 0.152.
 */
package dyvil.source;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.io.Files;
import dyvil.source.Source;
import dyvil.source.TextSource;
import dyvil.tuple.Tuple;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"file"})
public class FileSource
implements Source,
Serializable {
    protected final @NonNull File file;
    private TextSource _textSource = null;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileSource fileSource = (FileSource)object;
        return ((Object)this.file).equals(fileSource.file);
    }

    public int hashCode() {
        File file = this.file;
        return (31 + (file != null ? ((Object)file).hashCode() : 0)) * 31;
    }

    public String toString() {
        return "FileSource(" + this.file + ")";
    }

    public @NonNull File file() {
        return this.file;
    }

    public FileSource(@NonNull File file) {
        this.file = file;
    }

    @DyvilName(value="textSource")
    public @NonNull TextSource getTextSource() {
        TextSource textSource = this._textSource;
        if (textSource != null) {
            return textSource;
        }
        throw new RuntimeException("FileSource not yet loaded");
    }

    @Override
    @DyvilName(value="filePath")
    public @NonNull String getFilePath() {
        String string = this.file.getPath();
        string.getClass();
        return string;
    }

    @Override
    public int lineCount() {
        return this.getTextSource().lineCount();
    }

    @Override
    public @NonNull String text() {
        return this.getTextSource().text();
    }

    @Override
    public @NonNull String line(int index) {
        String string = this.getTextSource().line(index);
        string.getClass();
        return string;
    }

    public void load() throws @NonNull IOException {
        this._textSource = new TextSource(Files.readText(this.file));
    }

    public static final @NonNull FileSource apply(@NonNull File file) {
        return new FileSource(file);
    }

    public static final @NonNull Tuple.Of1<@NonNull File> unapply(@NonNull FileSource value) {
        return new Tuple.Of1<File>(value.file);
    }

    public static final @Nullable Tuple.Of1<@NonNull File> unapply(@Primitive Object value) {
        return value instanceof FileSource ? FileSource.unapply((FileSource)value) : null;
    }
}

