/*
 * Decompiled with CFR 0.152.
 */
package dyvil.runtime.reference;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.reflect.MethodReflection;
import dyvil.reflect.ReflectUtils;
import dyvil.runtime.BytecodeDump;
import dyvil.runtime.TypeConverter;
import dyvilx.tools.asm.ClassWriter;
import dyvilx.tools.asm.MethodVisitor;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;

public class PropertyReferenceMetafactory {
    private static final int CLASS_VERSION = 52;
    private static final String FACTORY_NAME = "create$Ref";
    private static final String RECEIVER_NAME = "$receiver";
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final Class<?> targetClass;
    private final @NonNull MethodHandleInfo getterInfo;
    private final @NonNull MethodHandleInfo setterInfo;
    private final @NonNull String className;
    private final Class<?> refClass;
    private final @NonNull Class<?> refTargetClass;
    private final @NonNull String refTargetType;
    private final @Nullable String receiverType;
    private final @NonNull MethodType factoryType;
    private final MethodType constructorType;

    public PropertyReferenceMetafactory(@NonNull MethodHandles.Lookup caller, @NonNull MethodType invokedType, @NonNull MethodHandle getter, @NonNull MethodHandle setter) {
        this.targetClass = caller.lookupClass();
        this.factoryType = invokedType;
        this.constructorType = invokedType.changeReturnType(Void.TYPE);
        this.refClass = invokedType.returnType();
        this.getterInfo = caller.revealDirect(getter);
        this.setterInfo = caller.revealDirect(setter);
        this.receiverType = invokedType.parameterCount() == 0 ? null : 'L' + TypeConverter.getInternalName(invokedType.parameterType(0)) + ';';
        switch (this.refClass.getSimpleName()) {
            case "BooleanRef": {
                this.refTargetType = "Z";
                this.refTargetClass = Boolean.TYPE;
                break;
            }
            case "ByteRef": {
                this.refTargetType = "B";
                this.refTargetClass = Byte.TYPE;
                break;
            }
            case "ShortRef": {
                this.refTargetType = "S";
                this.refTargetClass = Short.TYPE;
                break;
            }
            case "CharRef": {
                this.refTargetType = "C";
                this.refTargetClass = Character.TYPE;
                break;
            }
            case "IntRef": {
                this.refTargetType = "I";
                this.refTargetClass = Integer.TYPE;
                break;
            }
            case "LongRef": {
                this.refTargetType = "J";
                this.refTargetClass = Long.TYPE;
                break;
            }
            case "FloatRef": {
                this.refTargetType = "F";
                this.refTargetClass = Float.TYPE;
                break;
            }
            case "DoubleRef": {
                this.refTargetType = "D";
                this.refTargetClass = Double.TYPE;
                break;
            }
            default: {
                this.refTargetType = "Ljava/lang/Object;";
                this.refTargetClass = Object.class;
            }
        }
        this.className = TypeConverter.getInternalName(this.targetClass) + "$PropertyRef$" + counter.incrementAndGet();
    }

    public @NonNull CallSite buildCallSite() throws Exception {
        Class<?> innerClass = this.spinInnerClass();
        if (this.receiverType == null) {
            Constructor[] ctrs = AccessController.doPrivileged(() -> {
                Constructor[] ctrs1 = innerClass.getDeclaredConstructors();
                if (ctrs1.length == 1) {
                    ctrs1[0].setAccessible(true);
                }
                return ctrs1;
            });
            if (ctrs.length != 1) {
                throw new Exception("Expected one constructor for " + innerClass.getCanonicalName() + ", got " + ctrs.length);
            }
            try {
                Object inst = ctrs[0].newInstance(new Object[0]);
                return new ConstantCallSite(MethodHandles.constant(this.refClass, inst));
            }
            catch (ReflectiveOperationException e) {
                throw new Exception("Exception instantiating property reference", e);
            }
        }
        try {
            ReflectUtils.UNSAFE.ensureClassInitialized(innerClass);
            return new ConstantCallSite(MethodReflection.LOOKUP.findStatic(innerClass, FACTORY_NAME, this.factoryType));
        }
        catch (ReflectiveOperationException e) {
            throw new Exception("Exception finding constructor", e);
        }
    }

    private Class<?> spinInnerClass() throws Exception {
        String refItf = TypeConverter.getInternalName(this.refClass);
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(52, 4113, this.className, null, "java/lang/Object", new String[]{refItf});
        if (this.receiverType != null) {
            classWriter.visitField(2, RECEIVER_NAME, this.receiverType, null, null).visitEnd();
        }
        this.generateConstructor(classWriter);
        if (this.receiverType != null) {
            this.generateFactory(classWriter);
        }
        this.generateGetter(classWriter);
        this.generateSetter(classWriter);
        this.generateToString(classWriter);
        classWriter.visitEnd();
        byte[] bytes = classWriter.toByteArray();
        BytecodeDump.dump(bytes, this.className);
        return ReflectUtils.UNSAFE.defineAnonymousClass(this.targetClass, bytes, null);
    }

    private void generateFactory(@NonNull ClassWriter classWriter) {
        MethodVisitor factory = classWriter.visitMethod(10, FACTORY_NAME, this.factoryType.toMethodDescriptorString(), null, null);
        factory.visitCode();
        factory.visitTypeInsn(187, this.className);
        factory.visitInsn(89);
        factory.visitVarInsn(25, 0);
        factory.visitMethodInsn(183, this.className, "<init>", this.constructorType.toMethodDescriptorString(), false);
        factory.visitInsn(176);
        factory.visitMaxs(-1, -1);
        factory.visitEnd();
    }

    private void generateConstructor(@NonNull ClassWriter classWriter) {
        MethodVisitor ctor = classWriter.visitMethod(2, "<init>", this.constructorType.toMethodDescriptorString(), null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        if (this.receiverType != null) {
            ctor.visitVarInsn(25, 0);
            ctor.visitVarInsn(25, 1);
            ctor.visitFieldInsn(181, this.className, RECEIVER_NAME, this.receiverType);
        }
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
    }

    private void writeReceiver(@NonNull MethodVisitor setter) {
        if (this.receiverType != null) {
            setter.visitVarInsn(25, 0);
            setter.visitFieldInsn(180, this.className, RECEIVER_NAME, this.receiverType);
        }
    }

    private void writeMethod(@NonNull MethodVisitor setter, @NonNull MethodHandleInfo handleInfo) {
        setter.visitMethodInsn(TypeConverter.invocationOpcode(handleInfo.getReferenceKind()), TypeConverter.getInternalName(handleInfo.getDeclaringClass()), handleInfo.getName(), handleInfo.getMethodType().toMethodDescriptorString(), handleInfo.getDeclaringClass().isInterface());
    }

    private void generateGetter(@NonNull ClassWriter classWriter) {
        MethodVisitor getter = classWriter.visitMethod(1, "get", "()" + this.refTargetType, null, null);
        getter.visitCode();
        this.writeReceiver(getter);
        this.writeMethod(getter, this.getterInfo);
        TypeConverter.convertType(getter, this.getterInfo.getMethodType().returnType(), this.refTargetClass, this.refTargetClass);
        getter.visitInsn(TypeConverter.getReturnOpcode(this.refTargetClass));
        getter.visitMaxs(-1, -1);
        getter.visitEnd();
    }

    private void generateSetter(@NonNull ClassWriter classWriter) {
        MethodType setterType = this.setterInfo.getMethodType();
        TypeDescriptor.OfField setterParamType = setterType.parameterType(0);
        TypeDescriptor.OfField setterReturnType = setterType.returnType();
        MethodVisitor setter = classWriter.visitMethod(1, "set", "(" + this.refTargetType + ")V", null, null);
        setter.visitCode();
        this.writeReceiver(setter);
        setter.visitVarInsn(TypeConverter.getLoadOpcode(this.refTargetClass), 1);
        TypeConverter.convertType(setter, this.refTargetClass, setterParamType, setterParamType);
        this.writeMethod(setter, this.setterInfo);
        if (setterReturnType != Void.TYPE) {
            if (setterReturnType == Long.TYPE || setterReturnType == Double.TYPE) {
                setter.visitInsn(88);
            } else {
                setter.visitInsn(87);
            }
        }
        setter.visitInsn(177);
        setter.visitMaxs(-1, -1);
        setter.visitEnd();
    }

    private void generateToString(@NonNull ClassWriter classWriter) {
        MethodVisitor toString = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        toString.visitCode();
        toString.visitLdcInsn('<' + this.refClass.getName() + ">");
        toString.visitInsn(176);
        toString.visitMaxs(-1, -1);
        toString.visitEnd();
    }
}

