/*
 * Decompiled with CFR 0.152.
 */
package dyvil.runtime.lambda;

import dyvil.annotation.internal.NonNull;
import dyvil.reflect.MethodReflection;
import dyvil.reflect.ReflectUtils;
import dyvil.runtime.BytecodeDump;
import dyvil.runtime.TypeConverter;
import dyvil.runtime.lambda.AbstractLMF;
import dyvilx.tools.asm.ClassWriter;
import dyvilx.tools.asm.FieldVisitor;
import dyvilx.tools.asm.MethodVisitor;
import dyvilx.tools.asm.Type;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicInteger;

public final class AnonymousClassLMF
extends AbstractLMF {
    private static final int CLASSFILE_VERSION = 52;
    private static final String NAME_FACTORY = "get$Lambda";
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final @NonNull String implMethodClassName;
    private final String implMethodName;
    private final String implMethodDesc;
    private final Class<?> implMethodReturnClass;
    private final MethodType constructorType;
    private final @NonNull ClassWriter cw;
    private final @NonNull String[] argNames;
    private final @NonNull String[] argDescs;
    private final @NonNull String lambdaClassName;
    private String toString;

    public AnonymousClassLMF(@NonNull MethodHandles.Lookup caller, @NonNull MethodType invokedType, String samMethodName, MethodType samMethodType, @NonNull MethodHandle implMethod, MethodType instantiatedMethodType, String toString) throws LambdaConversionException {
        super(caller, invokedType, samMethodName, samMethodType, implMethod, instantiatedMethodType);
        this.implMethodClassName = TypeConverter.getInternalName(this.implDefiningClass);
        this.implMethodName = this.implInfo.getName();
        this.implMethodDesc = this.implMethodType.toMethodDescriptorString();
        this.implMethodReturnClass = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        this.constructorType = invokedType.changeReturnType(Void.TYPE);
        this.lambdaClassName = TypeConverter.getInternalName(this.targetClass) + "$Lambda$" + counter.incrementAndGet();
        this.cw = new ClassWriter(1);
        int parameterCount = this.parameterCount;
        if (parameterCount > 0) {
            this.argNames = new String[parameterCount];
            this.argDescs = new String[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                this.argNames[i] = "arg$" + (i + 1);
                this.argDescs[i] = Type.getDescriptor(invokedType.parameterType(i));
            }
        } else {
            this.argDescs = null;
            this.argNames = null;
        }
        this.toString = toString;
    }

    @Override
    public @NonNull CallSite buildCallSite() throws LambdaConversionException {
        Class<?> innerClass = this.spinInnerClass();
        if (this.parameterCount == 0) {
            Constructor<?>[] ctrs = innerClass.getDeclaredConstructors();
            if (ctrs.length != 1) {
                String message = "Expected one lambda constructor for " + innerClass.getCanonicalName() + ", got " + ctrs.length;
                throw new LambdaConversionException(message);
            }
            try {
                Constructor<?> ctr = ctrs[0];
                ctr.setAccessible(true);
                Object inst = ctr.newInstance(new Object[0]);
                return new ConstantCallSite(MethodHandles.constant(this.samBase, inst));
            }
            catch (ReflectiveOperationException e) {
                throw new LambdaConversionException("Exception instantiating lambda object", e);
            }
        }
        try {
            ReflectUtils.UNSAFE.ensureClassInitialized(innerClass);
            return new ConstantCallSite(MethodReflection.LOOKUP.findStatic(innerClass, NAME_FACTORY, this.invokedType));
        }
        catch (ReflectiveOperationException e) {
            throw new LambdaConversionException("Exception finding constructor", e);
        }
    }

    private Class<?> spinInnerClass() throws LambdaConversionException {
        String samIntf = TypeConverter.getInternalName(this.samBase);
        this.cw.visit(52, 4144, this.lambdaClassName, null, "java/lang/Object", new String[]{samIntf});
        if (this.parameterCount != 0) {
            for (int i = 0; i < this.parameterCount; ++i) {
                FieldVisitor fv = this.cw.visitField(18, this.argNames[i], this.argDescs[i], null, null);
                fv.visitEnd();
            }
            this.generateFactory();
        }
        this.generateConstructor();
        this.generateToString();
        this.generateSAM();
        this.cw.visitEnd();
        byte[] bytes = this.cw.toByteArray();
        BytecodeDump.dump(bytes, this.lambdaClassName);
        return ReflectUtils.UNSAFE.defineAnonymousClass(this.targetClass, bytes, null);
    }

    private void generateFactory() {
        MethodVisitor m = this.cw.visitMethod(10, NAME_FACTORY, this.invokedType.toMethodDescriptorString(), null, null);
        m.visitCode();
        m.visitTypeInsn(187, this.lambdaClassName);
        m.visitInsn(89);
        int parameterCount = this.parameterCount;
        int varIndex = 0;
        for (int typeIndex = 0; typeIndex < parameterCount; ++typeIndex) {
            TypeDescriptor.OfField argType = this.invokedType.parameterType(typeIndex);
            m.visitVarInsn(TypeConverter.getLoadOpcode(argType), varIndex);
            varIndex += TypeConverter.getParameterSize(argType);
        }
        m.visitMethodInsn(183, this.lambdaClassName, "<init>", this.constructorType.toMethodDescriptorString(), false);
        m.visitInsn(176);
        m.visitMaxs(-1, -1);
        m.visitEnd();
    }

    private void generateConstructor() {
        MethodVisitor ctor = this.cw.visitMethod(2, "<init>", this.constructorType.toMethodDescriptorString(), null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        int parameterCount = this.parameterCount;
        int lvIndex = 0;
        for (int i = 0; i < parameterCount; ++i) {
            ctor.visitVarInsn(25, 0);
            TypeDescriptor.OfField argType = this.invokedType.parameterType(i);
            ctor.visitVarInsn(TypeConverter.getLoadOpcode(argType), lvIndex + 1);
            lvIndex += TypeConverter.getParameterSize(argType);
            ctor.visitFieldInsn(181, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
        }
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
    }

    private void generateToString() {
        MethodVisitor mv = this.cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitLdcInsn(this.toString);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void generateSAM() {
        MethodVisitor mv = this.cw.visitMethod(1, this.samMethodName, this.samMethodType.toMethodDescriptorString(), null, null);
        mv.visitCode();
        if (this.implKind == 8) {
            mv.visitTypeInsn(187, this.implMethodClassName);
            mv.visitInsn(89);
        }
        for (int i = 0; i < this.parameterCount; ++i) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
        }
        this.convertArgumentTypes(mv, this.samMethodType);
        mv.visitMethodInsn(TypeConverter.invocationOpcode(this.implKind), this.implMethodClassName, this.implMethodName, this.implMethodDesc, this.implDefiningClass.isInterface());
        TypeDescriptor.OfField samReturnClass = this.samMethodType.returnType();
        TypeConverter.convertType(mv, this.implMethodReturnClass, samReturnClass, samReturnClass);
        mv.visitInsn(TypeConverter.getReturnOpcode(samReturnClass));
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void convertArgumentTypes(@NonNull MethodVisitor mv, @NonNull MethodType samType) {
        int samReceiverLength;
        int lvIndex = 0;
        if (this.implIsInstanceMethod && this.parameterCount == 0) {
            samReceiverLength = 1;
            TypeDescriptor.OfField rcvrType = samType.parameterType(0);
            mv.visitVarInsn(TypeConverter.getLoadOpcode(rcvrType), lvIndex + 1);
            lvIndex += TypeConverter.getParameterSize(rcvrType);
            TypeConverter.convertType(mv, rcvrType, this.implDefiningClass, this.instantiatedMethodType.parameterType(0));
        } else {
            samReceiverLength = 0;
        }
        int samParametersLength = samType.parameterCount();
        int argOffset = this.implMethodType.parameterCount() - samParametersLength;
        for (int i = samReceiverLength; i < samParametersLength; ++i) {
            TypeDescriptor.OfField argType = samType.parameterType(i);
            mv.visitVarInsn(TypeConverter.getLoadOpcode(argType), lvIndex + 1);
            lvIndex += TypeConverter.getParameterSize(argType);
            TypeConverter.convertType(mv, argType, this.implMethodType.parameterType(argOffset + i), this.instantiatedMethodType.parameterType(i));
        }
    }
}

