/*
 * Decompiled with CFR 0.152.
 */
package dyvil.runtime.lambda;

import dyvil.annotation.internal.NonNull;
import dyvil.runtime.Wrapper;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public abstract class AbstractLMF {
    final Class<?> targetClass;
    protected final @NonNull MethodType invokedType;
    protected final int parameterCount;
    protected final Class<?> samBase;
    protected final String samMethodName;
    protected final MethodType samMethodType;
    protected final @NonNull MethodHandle implMethod;
    protected final @NonNull MethodHandleInfo implInfo;
    protected final int implKind;
    protected final boolean implIsInstanceMethod;
    protected final Class<?> implDefiningClass;
    protected final MethodType implMethodType;
    protected final MethodType instantiatedMethodType;

    protected AbstractLMF( @NonNull MethodHandles.Lookup caller, @NonNull MethodType invokedType, String samMethodName, MethodType samMethodType, @NonNull MethodHandle implMethod, MethodType instantiatedMethodType) throws LambdaConversionException {
        if ((caller.lookupModes() & 2) == 0) {
            throw new LambdaConversionException(String.format("Invalid caller: %s", caller.lookupClass().getName()));
        }
        this.targetClass = caller.lookupClass();
        this.invokedType = invokedType;
        this.samBase = invokedType.returnType();
        this.parameterCount = invokedType.parameterCount();
        this.samMethodName = samMethodName;
        this.samMethodType = samMethodType;
        this.implMethod = implMethod;
        this.implInfo = caller.revealDirect(implMethod);
        this.implKind = this.implInfo.getReferenceKind();
        this.implIsInstanceMethod = this.implKind == 5 || this.implKind == 7 || this.implKind == 9;
        this.implDefiningClass = this.implInfo.getDeclaringClass();
        this.implMethodType = this.implInfo.getMethodType();
        this.instantiatedMethodType = instantiatedMethodType;
        if (!this.samBase.isInterface()) {
            throw new LambdaConversionException(String.format("Functional interface %s is not an interface", this.samBase.getName()));
        }
    }

    public abstract CallSite buildCallSite() throws LambdaConversionException;

    public void validateMetafactoryArgs() throws LambdaConversionException {
        int samStart;
        int capturedStart;
        switch (this.implKind) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new LambdaConversionException(String.format("Unsupported MethodHandle kind: %s", this.implInfo));
            }
        }
        int implArity = this.implMethodType.parameterCount();
        int receiverArity = this.implIsInstanceMethod ? 1 : 0;
        int capturedArity = this.invokedType.parameterCount();
        int samArity = this.samMethodType.parameterCount();
        int instantiatedArity = this.instantiatedMethodType.parameterCount();
        if (implArity + receiverArity != capturedArity + samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d captured parameters, %d functional interface method parameters, %d implementation parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, capturedArity, samArity, implArity));
        }
        if (instantiatedArity != samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d instantiated parameters, %d functional interface method parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, instantiatedArity, samArity));
        }
        if (this.implIsInstanceMethod) {
            TypeDescriptor.OfField receiverClass;
            if (capturedArity == 0) {
                capturedStart = 0;
                samStart = 1;
                receiverClass = this.instantiatedMethodType.parameterType(0);
            } else {
                capturedStart = 1;
                samStart = 0;
                receiverClass = this.invokedType.parameterType(0);
            }
            if (!AbstractLMF.isAdaptableTo(receiverClass, this.implDefiningClass, false)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation type %s", receiverClass, this.implDefiningClass));
            }
            TypeDescriptor.OfField implReceiverClass = this.implMethod.type().parameterType(0);
            if (implReceiverClass != this.implDefiningClass && !((Class)implReceiverClass).isAssignableFrom((Class<?>)receiverClass)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation receiver type %s", receiverClass, implReceiverClass));
            }
        } else {
            capturedStart = 0;
            samStart = 0;
        }
        int implFromCaptured = capturedArity - capturedStart;
        for (int i = 0; i < implFromCaptured; ++i) {
            TypeDescriptor.OfField implParamType = this.implMethodType.parameterType(i);
            TypeDescriptor.OfField capturedParamType = this.invokedType.parameterType(i + capturedStart);
            if (capturedParamType.equals(implParamType)) continue;
            throw new LambdaConversionException(String.format("Type mismatch in captured lambda parameter %d: expecting %s, found %s", i, capturedParamType, implParamType));
        }
        int samOffset = samStart - implFromCaptured;
        for (int i = implFromCaptured; i < implArity; ++i) {
            TypeDescriptor.OfField implParamType = this.implMethodType.parameterType(i);
            TypeDescriptor.OfField instantiatedParamType = this.instantiatedMethodType.parameterType(i + samOffset);
            if (AbstractLMF.isAdaptableTo(instantiatedParamType, implParamType, true)) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda argument %d: %s is not convertible to %s", i, instantiatedParamType, implParamType));
        }
        TypeDescriptor.OfField expectedType = this.instantiatedMethodType.returnType();
        TypeDescriptor.OfField<Class<?>> actualReturnType = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        TypeDescriptor.OfField samReturnType = this.samMethodType.returnType();
        if (!AbstractLMF.isAdaptableToAsReturn(actualReturnType, expectedType)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda return: %s is not convertible to %s", actualReturnType, expectedType));
        }
        if (!AbstractLMF.isAdaptableToAsReturnStrict(expectedType, samReturnType)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda expected return: %s is not convertible to %s", expectedType, samReturnType));
        }
    }

    private static boolean isAdaptableTo(@NonNull Class<?> fromType, @NonNull Class<?> toType, boolean strict) {
        if (fromType.equals(toType)) {
            return true;
        }
        if (fromType.isPrimitive()) {
            Wrapper wfrom = Wrapper.forPrimitiveType(fromType);
            if (toType.isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return toType.isAssignableFrom(wfrom.wrapperType());
        }
        if (toType.isPrimitive()) {
            Wrapper wfrom;
            if (Wrapper.isWrapperType(fromType) && (wfrom = Wrapper.forWrapperType(fromType)).primitiveType().isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return !strict;
        }
        return !strict || toType.isAssignableFrom(fromType);
    }

    private static boolean isAdaptableToAsReturn(@NonNull Class<?> fromType, @NonNull Class<?> toType) {
        return toType.equals(Void.TYPE) || AbstractLMF.isAdaptableTo(fromType, toType, false);
    }

    private static boolean isAdaptableToAsReturnStrict(@NonNull Class<?> fromType, @NonNull Class<?> toType) {
        return AbstractLMF.isAdaptableTo(fromType, toType, true);
    }
}

