/*
 * Decompiled with CFR 0.152.
 */
package dyvil.runtime.annotation;

import dyvil.annotation.internal.NonNull;
import dyvil.reflect.MethodReflection;
import dyvil.reflect.ReflectUtils;
import dyvil.runtime.BytecodeDump;
import dyvil.runtime.TypeConverter;
import dyvilx.tools.asm.ClassWriter;
import dyvilx.tools.asm.FieldVisitor;
import dyvilx.tools.asm.MethodVisitor;
import dyvilx.tools.asm.Type;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicInteger;

public final class AnnotationProxyFactory {
    private static final int CLASSFILE_VERSION = 52;
    private static final String NAME_FACTORY = "get$Proxy";
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final MethodType constructorType;
    private final int parameterCount;
    private final @NonNull String[] argNames;
    private final @NonNull String[] argDescs;
    private final @NonNull String className;
    private final Class targetClass;
    private final @NonNull MethodType invokedType;
    private final Class annotationType;

    public AnnotationProxyFactory(@NonNull MethodHandles.Lookup caller, @NonNull MethodType invokedType, Object ... argumentNames) throws Exception {
        this.invokedType = invokedType;
        this.constructorType = invokedType.changeReturnType(Void.TYPE);
        this.annotationType = invokedType.returnType();
        this.targetClass = caller.lookupClass();
        this.className = this.targetClass.getName().replace('.', '/') + "$Annotation$" + counter.incrementAndGet();
        int parameterCount = this.parameterCount = argumentNames.length;
        if (parameterCount > 0) {
            this.argNames = new String[parameterCount];
            this.argDescs = new String[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                this.argNames[i] = argumentNames[i].toString();
                this.argDescs[i] = Type.getDescriptor(invokedType.parameterType(i));
            }
        } else {
            this.argNames = null;
            this.argDescs = null;
        }
    }

    public @NonNull CallSite buildCallSite() throws Exception {
        Class<?> innerClass = this.spinInnerClass();
        if (this.parameterCount == 0) {
            Constructor<?>[] ctrs = innerClass.getDeclaredConstructors();
            if (ctrs.length != 1) {
                String message = "Expected one annotation constructor for " + innerClass.getCanonicalName() + ", got " + ctrs.length;
                throw new Exception(message);
            }
            try {
                Constructor<?> ctr = ctrs[0];
                ctr.setAccessible(true);
                Object inst = ctr.newInstance(new Object[0]);
                return new ConstantCallSite(MethodHandles.constant(this.annotationType, inst));
            }
            catch (ReflectiveOperationException e) {
                throw new Exception("Exception instantiating annotation proxy", e);
            }
        }
        try {
            ReflectUtils.UNSAFE.ensureClassInitialized(innerClass);
            return new ConstantCallSite(MethodReflection.LOOKUP.findStatic(innerClass, NAME_FACTORY, this.invokedType));
        }
        catch (ReflectiveOperationException e) {
            throw new Exception("Exception finding constructor", e);
        }
    }

    private Class<?> spinInnerClass() {
        String annotationItf = this.annotationType.getName().replace('.', '/');
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(52, 4144, this.className, null, "java/lang/Object", new String[]{annotationItf});
        if (this.parameterCount > 0) {
            for (int i = 0; i < this.parameterCount; ++i) {
                FieldVisitor fv = classWriter.visitField(18, this.argNames[i], this.argDescs[i], null, null);
                fv.visitEnd();
            }
            this.generateFactory(classWriter);
        }
        this.generateConstructor(classWriter);
        this.generateAnnotationType(classWriter);
        this.generateMethods(classWriter);
        this.generateToString(classWriter);
        classWriter.visitEnd();
        byte[] bytes = classWriter.toByteArray();
        BytecodeDump.dump(bytes, this.className);
        return ReflectUtils.UNSAFE.defineAnonymousClass(this.targetClass, bytes, null);
    }

    private void generateFactory(@NonNull ClassWriter classWriter) {
        MethodVisitor factory = classWriter.visitMethod(10, NAME_FACTORY, this.invokedType.toMethodDescriptorString(), null, null);
        factory.visitCode();
        factory.visitTypeInsn(187, this.className);
        factory.visitInsn(89);
        int localIndex = 0;
        for (int typeIndex = 0; typeIndex < this.parameterCount; ++typeIndex) {
            TypeDescriptor.OfField argType = this.invokedType.parameterType(typeIndex);
            factory.visitVarInsn(TypeConverter.getLoadOpcode(argType), localIndex);
            localIndex += TypeConverter.getParameterSize(argType);
        }
        factory.visitMethodInsn(183, this.className, "<init>", this.constructorType.toMethodDescriptorString(), false);
        factory.visitInsn(176);
        factory.visitMaxs(-1, -1);
        factory.visitEnd();
    }

    private void generateConstructor(@NonNull ClassWriter classWriter) {
        MethodVisitor ctor = classWriter.visitMethod(2, "<init>", this.constructorType.toMethodDescriptorString(), null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        int localIndex = 0;
        for (int i = 0; i < this.parameterCount; ++i) {
            ctor.visitVarInsn(25, 0);
            TypeDescriptor.OfField argType = this.invokedType.parameterType(i);
            ctor.visitVarInsn(TypeConverter.getLoadOpcode(argType), localIndex + 1);
            localIndex += TypeConverter.getParameterSize(argType);
            ctor.visitFieldInsn(181, this.className, this.argNames[i], this.argDescs[i]);
        }
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
    }

    private void generateMethods(@NonNull ClassWriter classWriter) {
        for (int i = 0; i < this.parameterCount; ++i) {
            MethodVisitor methodVisitor = classWriter.visitMethod(1, this.argNames[i], "()" + this.argDescs[i], null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, this.argNames[i], this.argDescs[i]);
            methodVisitor.visitInsn(TypeConverter.getReturnOpcode(this.invokedType.parameterType(i)));
            methodVisitor.visitMaxs(-1, -1);
            methodVisitor.visitEnd();
        }
    }

    private void generateAnnotationType(@NonNull ClassWriter classWriter) {
        MethodVisitor annotationType = classWriter.visitMethod(1, "annotationType", "()Ljava/lang/Class;", null, null);
        annotationType.visitCode();
        annotationType.visitLdcInsn(Type.getType(this.annotationType));
        annotationType.visitInsn(176);
        annotationType.visitMaxs(-1, -1);
        annotationType.visitEnd();
    }

    private void generateToString(@NonNull ClassWriter classWriter) {
        MethodVisitor toString = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        toString.visitCode();
        toString.visitLdcInsn('<' + this.annotationType.getName() + ">");
        toString.visitInsn(176);
        toString.visitMaxs(-1, -1);
        toString.visitEnd();
    }
}

