/*
 * Decompiled with CFR 0.152.
 */
package dyvil.runtime;

import dyvil.annotation.internal.NonNull;

public final class Wrapper
extends Enum<Wrapper> {
    public static final /* enum */ Wrapper BOOLEAN = new Wrapper('Z', Boolean.TYPE, Boolean.class, 1);
    public static final /* enum */ Wrapper BYTE = new Wrapper('B', Byte.TYPE, Byte.class, 1);
    public static final /* enum */ Wrapper SHORT = new Wrapper('S', Short.TYPE, Short.class, 2);
    public static final /* enum */ Wrapper CHAR = new Wrapper('C', Character.TYPE, Character.class, 18);
    public static final /* enum */ Wrapper INT = new Wrapper('I', Integer.TYPE, Integer.class, 4);
    public static final /* enum */ Wrapper LONG = new Wrapper('J', Long.TYPE, Long.class, 8);
    public static final /* enum */ Wrapper FLOAT = new Wrapper('F', Float.TYPE, Float.class, 36);
    public static final /* enum */ Wrapper DOUBLE = new Wrapper('D', Double.TYPE, Double.class, 40);
    public static final /* enum */ Wrapper OBJECT = new Wrapper('L', Object.class, Object.class, 72);
    public static final /* enum */ Wrapper VOID = new Wrapper('V', Void.TYPE, Void.class, 64);
    private static final int SIZE_MASK = 15;
    private static final int UNSIGNED = 16;
    private static final int FLOATING = 32;
    private static final int OTHER = 64;
    private final char basicTypeChar;
    private final @NonNull Class primitiveClass;
    private final @NonNull Class wrapperClass;
    private final @NonNull String primitiveSimpleName;
    private final @NonNull String wrapperSimpleName;
    private final byte flags;
    private static final Wrapper[] FROM_PRIMITIVE;
    private static final Wrapper[] FROM_WRAPPER;
    private static final Wrapper[] FROM_CHAR;
    private static final /* synthetic */ Wrapper[] $VALUES;

    public static Wrapper[] values() {
        return (Wrapper[])$VALUES.clone();
    }

    public static Wrapper valueOf(String name) {
        return Enum.valueOf(Wrapper.class, name);
    }

    private Wrapper(@NonNull char basicTypeChar, Class<?> primitive, Class<?> wrapper, int flags) {
        this.basicTypeChar = basicTypeChar;
        this.primitiveClass = primitive;
        this.wrapperClass = wrapper;
        this.primitiveSimpleName = primitive.getSimpleName();
        this.wrapperSimpleName = wrapper.getSimpleName();
        this.flags = (byte)flags;
    }

    public static @NonNull Class<?> referenceType(@NonNull Class<?> forClass) {
        if (forClass.isPrimitive()) {
            return Wrapper.forPrimitiveType(forClass).wrapperClass;
        }
        return forClass;
    }

    public static Wrapper forBasicType(char c) {
        return FROM_CHAR[Wrapper.hashChar(c)];
    }

    public static Wrapper forPrimitiveType(@NonNull Class<?> c) {
        return FROM_PRIMITIVE[Wrapper.hashPrimitive(c)];
    }

    public static Wrapper forWrapperType(@NonNull Class<?> c) {
        return FROM_WRAPPER[Wrapper.hashWrapper(c)];
    }

    public static boolean isWrapperType(@NonNull Class<?> wrapperClass) {
        Wrapper wrapper = FROM_WRAPPER[Wrapper.hashWrapper(wrapperClass)];
        return wrapper != null && wrapper.wrapperClass == wrapperClass;
    }

    private static int hashPrimitive(@NonNull Class<?> primitiveClass) {
        String className = primitiveClass.getName();
        if (className.length() < 3) {
            return 0;
        }
        return className.charAt(0) + className.charAt(2) & 0xF;
    }

    private static int hashWrapper(@NonNull Class<?> wrapperClass) {
        String className = wrapperClass.getName();
        if (className.length() < 13) {
            return 0;
        }
        return 3 * className.charAt(11) + className.charAt(12) & 0xF;
    }

    private static int hashChar(char typeChar) {
        return typeChar + (typeChar >> 1) & 0xF;
    }

    public char basicTypeChar() {
        return this.basicTypeChar;
    }

    public @NonNull Class primitiveType() {
        return this.primitiveClass;
    }

    public @NonNull Class wrapperType() {
        return this.wrapperClass;
    }

    public @NonNull String primitiveSimpleName() {
        return this.primitiveSimpleName;
    }

    public @NonNull String wrapperSimpleName() {
        return this.wrapperSimpleName;
    }

    public boolean isConvertibleFrom(@NonNull Wrapper wrapper) {
        if (this == wrapper) {
            return true;
        }
        if (this.compareTo(wrapper) < 0) {
            return false;
        }
        if ((this.flags & wrapper.flags & 0x10) != 0) {
            if ((this.flags & 0x40) != 0) {
                return true;
            }
            return wrapper == CHAR;
        }
        return true;
    }

    public boolean isSigned() {
        return (this.flags & 0x10) == 0;
    }

    public boolean isFloating() {
        return (this.flags & 0x20) != 0;
    }

    static {
        $VALUES = new Wrapper[]{BOOLEAN, BYTE, SHORT, CHAR, INT, LONG, FLOAT, DOUBLE, OBJECT, VOID};
        FROM_PRIMITIVE = new Wrapper[16];
        FROM_WRAPPER = new Wrapper[16];
        FROM_CHAR = new Wrapper[16];
        for (Wrapper localWrapper : Wrapper.values()) {
            int primitiveHash = Wrapper.hashPrimitive(localWrapper.primitiveClass);
            int wrapperHash = Wrapper.hashWrapper(localWrapper.wrapperClass);
            int charHash = Wrapper.hashChar(localWrapper.basicTypeChar);
            assert (FROM_PRIMITIVE[primitiveHash] == null);
            assert (FROM_WRAPPER[wrapperHash] == null);
            assert (FROM_CHAR[charHash] == null);
            Wrapper.FROM_PRIMITIVE[primitiveHash] = localWrapper;
            Wrapper.FROM_WRAPPER[wrapperHash] = localWrapper;
            Wrapper.FROM_CHAR[charHash] = localWrapper;
        }
    }
}

