/*
 * Decompiled with CFR 0.152.
 */
package dyvil.runtime;

import dyvil.annotation.internal.NonNull;
import dyvil.runtime.Wrapper;
import dyvilx.tools.asm.MethodVisitor;
import dyvilx.tools.asm.Type;

public class TypeConverter {
    private static final int NUM_WRAPPERS = Wrapper.values().length;
    private static final String NAME_OBJECT = "java/lang/Object";
    private static final String WRAPPER_PREFIX = "Ljava/lang/";
    private static final String NAME_BOX_METHOD = "valueOf";
    private static final String NAME_UNBOX_METHOD = "Value";
    private static final int[][] wideningOpcodes = new int[NUM_WRAPPERS][NUM_WRAPPERS];
    private static final Wrapper[] FROM_WRAPPER_NAME = new Wrapper[16];
    private static final Wrapper[] FROM_TYPE_SORT = new Wrapper[16];

    private static void initWidening(@NonNull Wrapper to, int opcode, Wrapper ... from) {
        for (Wrapper f : from) {
            TypeConverter.wideningOpcodes[f.ordinal()][to.ordinal()] = opcode;
        }
    }

    private static int hashWrapperName(@NonNull String xn) {
        if (xn.length() < 3) {
            return 0;
        }
        return (3 * xn.charAt(1) + xn.charAt(2)) % 16;
    }

    private static Wrapper wrapperOrNullFromDescriptor(@NonNull String desc) {
        if (!desc.startsWith(WRAPPER_PREFIX)) {
            return null;
        }
        String cname = desc.substring(WRAPPER_PREFIX.length(), desc.length() - 1);
        Wrapper w = FROM_WRAPPER_NAME[TypeConverter.hashWrapperName(cname)];
        if (w == null || w.wrapperSimpleName().equals(cname)) {
            return w;
        }
        return null;
    }

    private static @NonNull String wrapperName(@NonNull Wrapper w) {
        return "java/lang/" + w.wrapperSimpleName();
    }

    private static @NonNull String boxingDescriptor(@NonNull Wrapper w) {
        return "(" + w.basicTypeChar() + ")Ljava/lang/" + w.wrapperSimpleName() + ";";
    }

    private static @NonNull String unboxingDescriptor(@NonNull Wrapper w) {
        return "()" + w.basicTypeChar();
    }

    static void boxIfTypePrimitive(@NonNull MethodVisitor mv, @NonNull Type t) {
        Wrapper w = FROM_TYPE_SORT[t.getSort()];
        if (w != null) {
            TypeConverter.box(mv, w);
        }
    }

    static void widen(@NonNull MethodVisitor mv, @NonNull Wrapper ws, @NonNull Wrapper wt) {
        int opcode;
        if (ws != wt && (opcode = wideningOpcodes[ws.ordinal()][wt.ordinal()]) != 0) {
            mv.visitInsn(opcode);
        }
    }

    static void box(@NonNull MethodVisitor mv, @NonNull Wrapper w) {
        mv.visitMethodInsn(184, TypeConverter.wrapperName(w), NAME_BOX_METHOD, TypeConverter.boxingDescriptor(w), false);
    }

    static void unbox(@NonNull MethodVisitor mv, String wrapperClassName, @NonNull Wrapper wt) {
        mv.visitMethodInsn(182, wrapperClassName, wt.primitiveSimpleName() + NAME_UNBOX_METHOD, TypeConverter.unboxingDescriptor(wt), false);
    }

    private static @NonNull String descriptorToName(@NonNull String desc) {
        int last = desc.length() - 1;
        if (desc.charAt(0) == 'L' && desc.charAt(last) == ';') {
            return desc.substring(1, last);
        }
        return desc;
    }

    static void cast(@NonNull MethodVisitor mv, @NonNull String ds, @NonNull String dt) {
        String ns = TypeConverter.descriptorToName(ds);
        String nt = TypeConverter.descriptorToName(dt);
        if (!nt.equals(ns) && !nt.equals(NAME_OBJECT)) {
            mv.visitTypeInsn(192, nt);
        }
    }

    private boolean isPrimitive(Wrapper w) {
        return w != Wrapper.OBJECT;
    }

    private static Wrapper toWrapper(@NonNull String desc) {
        char first = desc.charAt(0);
        if (first == '[' || first == '(') {
            first = 'L';
        }
        return Wrapper.forBasicType(first);
    }

    public static void convertType(@NonNull MethodVisitor mv, @NonNull Class<?> arg, @NonNull Class<?> target, @NonNull Class<?> functional) {
        if (arg.equals(target) && arg.equals(functional)) {
            return;
        }
        if (arg == Void.TYPE) {
            if (target == Void.TYPE) {
                return;
            }
            if (target != Void.TYPE) {
                mv.visitInsn(1);
            }
            return;
        }
        if (target == Void.TYPE) {
            if (arg == Long.TYPE || arg == Double.TYPE) {
                mv.visitInsn(88);
                return;
            }
            mv.visitInsn(87);
            return;
        }
        if (arg.isPrimitive()) {
            Wrapper wArg = Wrapper.forPrimitiveType(arg);
            if (target.isPrimitive()) {
                TypeConverter.widen(mv, wArg, Wrapper.forPrimitiveType(target));
            } else {
                String dTarget = Type.getDescriptor(target);
                Wrapper wPrimTarget = TypeConverter.wrapperOrNullFromDescriptor(dTarget);
                if (wPrimTarget != null) {
                    TypeConverter.widen(mv, wArg, wPrimTarget);
                    TypeConverter.box(mv, wPrimTarget);
                } else {
                    TypeConverter.box(mv, wArg);
                    TypeConverter.cast(mv, TypeConverter.wrapperName(wArg), dTarget);
                }
            }
        } else {
            String dSrc;
            String dArg = Type.getDescriptor(arg);
            if (functional.isPrimitive()) {
                dSrc = dArg;
            } else {
                dSrc = Type.getDescriptor(functional);
                TypeConverter.cast(mv, dArg, dSrc);
            }
            String dTarget = Type.getDescriptor(target);
            if (target.isPrimitive()) {
                Wrapper wTarget = TypeConverter.toWrapper(dTarget);
                Wrapper wps = TypeConverter.wrapperOrNullFromDescriptor(dSrc);
                if (wps != null) {
                    if (wps.isSigned() || wps.isFloating()) {
                        TypeConverter.unbox(mv, TypeConverter.wrapperName(wps), wTarget);
                    } else {
                        TypeConverter.unbox(mv, TypeConverter.wrapperName(wps), wps);
                        TypeConverter.widen(mv, wps, wTarget);
                    }
                } else {
                    String intermediate = TypeConverter.wrapperName(wTarget);
                    TypeConverter.cast(mv, dSrc, intermediate);
                    TypeConverter.unbox(mv, intermediate, wTarget);
                }
            } else {
                TypeConverter.cast(mv, dSrc, dTarget);
            }
        }
    }

    public static int invocationOpcode(int kind) throws InternalError {
        switch (kind) {
            case 6: {
                return 184;
            }
            case 8: {
                return 183;
            }
            case 5: {
                return 182;
            }
            case 9: {
                return 185;
            }
            case 7: {
                return 183;
            }
        }
        throw new InternalError("Unexpected invocation kind: " + kind);
    }

    public static String getInternalName(@NonNull Class<?> c) {
        return c.getName().replace('.', '/');
    }

    public static int getParameterSize(Class<?> c) {
        if (c == Void.TYPE) {
            return 0;
        }
        if (c == Long.TYPE || c == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    public static int getLoadOpcode(@NonNull Class<?> c) {
        if (c == Void.TYPE) {
            throw new InternalError("Unexpected void type of load opcode");
        }
        return 21 + TypeConverter.getOpcodeOffset(c);
    }

    public static int getReturnOpcode(@NonNull Class<?> c) {
        if (c == Void.TYPE) {
            return 177;
        }
        return 172 + TypeConverter.getOpcodeOffset(c);
    }

    private static int getOpcodeOffset(@NonNull Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Long.TYPE) {
                return 1;
            }
            if (c == Float.TYPE) {
                return 2;
            }
            if (c == Double.TYPE) {
                return 3;
            }
            return 0;
        }
        return 4;
    }

    static {
        for (Wrapper w : Wrapper.values()) {
            if (w.basicTypeChar() == 'L') continue;
            int wi = TypeConverter.hashWrapperName(w.wrapperSimpleName());
            assert (FROM_WRAPPER_NAME[wi] == null);
            TypeConverter.FROM_WRAPPER_NAME[wi] = w;
        }
        TypeConverter.initWidening(Wrapper.LONG, 133, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConverter.initWidening(Wrapper.LONG, 140, Wrapper.FLOAT);
        TypeConverter.initWidening(Wrapper.FLOAT, 134, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConverter.initWidening(Wrapper.FLOAT, 137, Wrapper.LONG);
        TypeConverter.initWidening(Wrapper.DOUBLE, 135, Wrapper.BYTE, Wrapper.SHORT, Wrapper.INT, Wrapper.CHAR);
        TypeConverter.initWidening(Wrapper.DOUBLE, 141, Wrapper.FLOAT);
        TypeConverter.initWidening(Wrapper.DOUBLE, 138, Wrapper.LONG);
        TypeConverter.FROM_TYPE_SORT[3] = Wrapper.BYTE;
        TypeConverter.FROM_TYPE_SORT[4] = Wrapper.SHORT;
        TypeConverter.FROM_TYPE_SORT[5] = Wrapper.INT;
        TypeConverter.FROM_TYPE_SORT[7] = Wrapper.LONG;
        TypeConverter.FROM_TYPE_SORT[2] = Wrapper.CHAR;
        TypeConverter.FROM_TYPE_SORT[6] = Wrapper.FLOAT;
        TypeConverter.FROM_TYPE_SORT[8] = Wrapper.DOUBLE;
        TypeConverter.FROM_TYPE_SORT[1] = Wrapper.BOOLEAN;
    }
}

