/*
 * Decompiled with CFR 0.152.
 */
package dyvil.runtime;

import dyvil.annotation.internal.NonNull;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.Method;

public class DynamicLinker {
    private static final MethodHandle CHECK_CLASS;
    private static final MethodHandle INVOKE_DYNAMIC;
    private static final MethodHandle CHECK_ISCLASS;
    private static final MethodHandle INVOKE_CLASSMETHOD;

    public static @NonNull CallSite linkMethod(@NonNull MethodHandles.Lookup lookup, @NonNull String name, @NonNull MethodType type) {
        return DynamicLinker.link(lookup, name, type, null, INVOKE_DYNAMIC);
    }

    public static @NonNull CallSite linkExtension(@NonNull MethodHandles.Lookup lookup, @NonNull String name, @NonNull MethodType type, @NonNull MethodHandle fallback) {
        return DynamicLinker.link(lookup, name, type, fallback, INVOKE_DYNAMIC);
    }

    public static @NonNull CallSite linkClassMethod(@NonNull MethodHandles.Lookup lookup, @NonNull String name, @NonNull MethodType type) {
        return DynamicLinker.link(lookup, name, type, null, INVOKE_CLASSMETHOD);
    }

    private static @NonNull CallSite link(@NonNull MethodHandles.Lookup lookup, @NonNull String name, @NonNull MethodType type, MethodHandle fallback, @NonNull MethodHandle dynamicTarget) {
        InliningCacheCallSite callSite = new InliningCacheCallSite(lookup, name, type, fallback);
        MethodHandle invokeDynamic = dynamicTarget.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(invokeDynamic);
        return callSite;
    }

    public static boolean checkClass(@NonNull Class<?> clazz, @NonNull Object receiver) {
        return receiver.getClass() == clazz;
    }

    public static boolean checkIsClass(@NonNull Class<?> clazz, @NonNull Class<?> receiver) {
        return receiver == clazz;
    }

    public static Object invokeDynamic(@NonNull InliningCacheCallSite callSite, Object @NonNull [] args) throws Throwable {
        MethodType type = callSite.type();
        if (callSite.depth >= 256) {
            return DynamicLinker.invokeVirtual(callSite, args, type);
        }
        Object receiver = args[0];
        if (receiver == null) {
            throw new NullPointerException();
        }
        Class<?> receiverClass = receiver.getClass();
        try {
            Method implementationMethod = receiverClass.getMethod(callSite.name, type.dropParameterTypes(0, 1).parameterArray());
            MethodHandle target = callSite.lookup.unreflect(implementationMethod).asType(type);
            return DynamicLinker.invokeWith(callSite, args, type, receiverClass, target, CHECK_CLASS);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            MethodHandle fallbackMethod = callSite.fallback;
            if (fallbackMethod != null) {
                return DynamicLinker.invokeWith(callSite, args, type, receiverClass, fallbackMethod, CHECK_CLASS);
            }
            throw ex;
        }
    }

    public static Object invokeClassMethod(@NonNull InliningCacheCallSite callSite, Object @NonNull [] args) throws Throwable {
        MethodType type = callSite.type();
        if (callSite.depth >= 256) {
            return DynamicLinker.invokeVirtual(callSite, args, type);
        }
        Class receiver = (Class)args[0];
        MethodType targetType = type.dropParameterTypes(0, 1);
        MethodHandle target = callSite.lookup.findStatic(receiver, callSite.name, targetType).asType(targetType);
        return DynamicLinker.invokeWith(callSite, args, type, receiver, MethodHandles.dropArguments(target, 0, new Class[]{Class.class}), CHECK_ISCLASS);
    }

    private static Object invokeVirtual(@NonNull InliningCacheCallSite callSite, Object @NonNull [] args, @NonNull MethodType type) throws Throwable {
        MethodHandle virtualTarget = callSite.lookup.findVirtual((Class<?>)type.parameterType(0), callSite.name, type.dropParameterTypes(0, 1));
        callSite.setTarget(virtualTarget);
        return virtualTarget.invokeWithArguments(args);
    }

    private static Object invokeWith(@NonNull InliningCacheCallSite callSite, Object @NonNull [] args, @NonNull MethodType type, @NonNull Class<?> receiverClass, @NonNull MethodHandle target, @NonNull MethodHandle receiverCheck) throws Throwable {
        MethodHandle test = receiverCheck.bindTo(receiverClass);
        test = test.asType(test.type().changeParameterType(0, (Class<?>)type.parameterType(0)));
        target = target.asFixedArity();
        MethodHandle guard = MethodHandles.guardWithTest(test, target, callSite.getTarget());
        ++callSite.depth;
        callSite.setTarget(guard);
        return target.invokeWithArguments(args);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            CHECK_CLASS = lookup.findStatic(DynamicLinker.class, "checkClass", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
            INVOKE_DYNAMIC = lookup.findStatic(DynamicLinker.class, "invokeDynamic", MethodType.methodType(Object.class, InliningCacheCallSite.class, Object[].class));
            INVOKE_CLASSMETHOD = lookup.findStatic(DynamicLinker.class, "invokeClassMethod", MethodType.methodType(Object.class, InliningCacheCallSite.class, Object[].class));
            CHECK_ISCLASS = lookup.findStatic(DynamicLinker.class, "checkIsClass", MethodType.methodType(Boolean.TYPE, Class.class, Class.class));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static class InliningCacheCallSite
    extends MutableCallSite {
        private static final int MAX_DEPTH = 256;
        final MethodHandles.Lookup lookup;
        final String name;
        final MethodHandle fallback;
        int depth;

        InliningCacheCallSite(MethodHandles.Lookup lookup, String name, @NonNull MethodType type, MethodHandle fallback) {
            super(type);
            this.lookup = lookup;
            this.name = name;
            this.fallback = fallback;
        }
    }
}

