/*
 * Decompiled with CFR 0.152.
 */
package dyvil.reflect.types;

import dyvil.lang.LiteralConvertible;
import dyvil.reflect.types.GenericType;
import dyvil.reflect.types.NamedType;
import dyvil.reflect.types.PrimitiveType;

@LiteralConvertible.FromString
@LiteralConvertible.FromClass
public interface Type<T> {
    public static <T> Type<T> apply(String className) {
        return new NamedType(className);
    }

    public static <T> Type<T> apply(String className, Type<?> ... generics) {
        return new GenericType(className, generics);
    }

    public static <T> Type<T> apply(Class<T> c) {
        return c.isPrimitive() ? PrimitiveType.apply(c) : new NamedType<T>(c);
    }

    public static <T> Type<T> apply(Class<T> c, Type<?> ... generics) {
        return new GenericType<T>(c, generics);
    }

    public Class<T> erasure();

    default public int typeArgumentCount() {
        return 0;
    }

    default public <R> Type<R> typeArgument(int index) {
        return null;
    }

    public String name();

    public String qualifiedName();

    public String toString();

    default public void toString(StringBuilder builder) {
        builder.append(this.toString());
    }

    default public String getSignature() {
        StringBuilder builder = new StringBuilder();
        this.appendSignature(builder);
        return builder.toString();
    }

    public void appendSignature(StringBuilder var1);

    default public String getGenericSignature() {
        StringBuilder builder = new StringBuilder();
        this.appendGenericSignature(builder);
        return builder.toString();
    }

    default public void appendGenericSignature(StringBuilder builder) {
        this.appendSignature(builder);
    }
}

